/*
 * Decompiled with CFR 0.152.
 */
package com.osbcp.cssparser;

import com.osbcp.cssparser.Chars;
import com.osbcp.cssparser.IncorrectFormatException;
import com.osbcp.cssparser.PropertyValue;
import com.osbcp.cssparser.Rule;
import com.osbcp.cssparser.Selector;
import com.osbcp.cssparser.State;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CSSParser {
    private final List<String> selectorNames;
    private String selectorName = "";
    private String propertyName = "";
    private String valueName = "";
    private final List<PropertyValue> values = new ArrayList<PropertyValue>();
    private State state = State.INSIDE_SELECTOR;
    private Character previousChar = null;
    private State beforeCommentMode = null;

    public static List<Rule> parse(String css) throws Exception {
        CSSParser parser = new CSSParser();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (css == null || css.trim().length() == 0) {
            return rules;
        }
        for (int i = 0; i < css.length(); ++i) {
            char c = css.charAt(i);
            if (i < css.length() - 1) {
                char nextC = css.charAt(i + 1);
                parser.parse(rules, Character.valueOf(c), Character.valueOf(nextC));
                continue;
            }
            parser.parse(rules, Character.valueOf(c), null);
        }
        return rules;
    }

    private CSSParser() {
        this.selectorNames = new ArrayList<String>();
    }

    private void parse(List<Rule> rules, Character c, Character nextC) throws Exception {
        if (Chars.SLASH.equals(c) && Chars.STAR.equals(nextC)) {
            if (this.state != State.INSIDE_COMMENT) {
                this.beforeCommentMode = this.state;
            }
            this.state = State.INSIDE_COMMENT;
        }
        switch (this.state) {
            case INSIDE_SELECTOR: {
                this.parseSelector(c);
                break;
            }
            case INSIDE_COMMENT: {
                this.parseComment(c);
                break;
            }
            case INSIDE_PROPERTY_NAME: {
                this.parsePropertyName(rules, c);
                break;
            }
            case INSIDE_VALUE: {
                this.parseValue(c);
                if (c != Chars.BRACKET_END) break;
                this.parsePropertyName(rules, c);
                break;
            }
            case INSIDE_VALUE_ROUND_BRACKET: {
                this.parseValueInsideRoundBrackets(c);
            }
        }
        this.previousChar = c;
    }

    private void parseValue(Character c) throws IncorrectFormatException {
        if (Chars.SEMI_COLON.equals(c) || Chars.BRACKET_END.equals(c)) {
            PropertyValue pv = new PropertyValue(this.propertyName.trim(), this.valueName.trim());
            this.values.add(pv);
            this.propertyName = "";
            this.valueName = "";
            this.state = State.INSIDE_PROPERTY_NAME;
            return;
        }
        if (Chars.ROUND_BRACKET_BEG.equals(c)) {
            this.valueName = this.valueName + Chars.ROUND_BRACKET_BEG;
            this.state = State.INSIDE_VALUE_ROUND_BRACKET;
            return;
        }
        if (Chars.COLON.equals(c)) {
            throw new IncorrectFormatException(IncorrectFormatException.ErrorCode.FOUND_COLON_WHILE_READING_VALUE, "The value '" + this.valueName.trim() + "' for property '" + this.propertyName.trim() + "' in the selector '" + this.selectorName.trim() + "' had a ':' character.");
        }
        this.valueName = this.valueName + c;
    }

    private void parseValueInsideRoundBrackets(Character c) throws IncorrectFormatException {
        if (Chars.ROUND_BRACKET_END.equals(c)) {
            this.valueName = this.valueName + Chars.ROUND_BRACKET_END;
            this.state = State.INSIDE_VALUE;
            return;
        }
        this.valueName = this.valueName + c;
    }

    private void parsePropertyName(List<Rule> rules, Character c) throws IncorrectFormatException {
        if (Chars.COLON.equals(c)) {
            this.state = State.INSIDE_VALUE;
            return;
        }
        if (Chars.SEMI_COLON.equals(c)) {
            throw new IncorrectFormatException(IncorrectFormatException.ErrorCode.FOUND_SEMICOLON_WHEN_READING_PROPERTY_NAME, "Unexpected character '" + c + "' for property '" + this.propertyName.trim() + "' in the selector '" + this.selectorName.trim() + "' should end with an ';', not with '}'.");
        }
        if (Chars.BRACKET_END.equals(c)) {
            Rule rule = new Rule();
            for (String s : this.selectorNames) {
                Selector selector = new Selector(s.trim());
                rule.addSelector(selector);
            }
            this.selectorNames.clear();
            Selector selector = new Selector(this.selectorName.trim());
            this.selectorName = "";
            rule.addSelector(selector);
            for (PropertyValue pv : this.values) {
                rule.addPropertyValue(pv);
            }
            this.values.clear();
            if (!rule.getPropertyValues().isEmpty()) {
                rules.add(rule);
            }
        } else {
            this.propertyName = this.propertyName + c;
            return;
        }
        this.state = State.INSIDE_SELECTOR;
    }

    private void parseComment(Character c) {
        if (Chars.STAR.equals(this.previousChar) && Chars.SLASH.equals(c)) {
            this.state = this.beforeCommentMode;
            return;
        }
    }

    private void parseSelector(Character c) throws IncorrectFormatException {
        if (Chars.BRACKET_BEG.equals(c)) {
            this.state = State.INSIDE_PROPERTY_NAME;
            return;
        }
        if (Chars.COMMA.equals(c)) {
            if (this.selectorName.trim().length() == 0) {
                throw new IncorrectFormatException(IncorrectFormatException.ErrorCode.FOUND_COLON_WHEN_READING_SELECTOR_NAME, "Found an ',' in a selector name without any actual name before it.");
            }
        } else {
            this.selectorName = this.selectorName + c;
            return;
        }
        this.selectorNames.add(this.selectorName.trim());
        this.selectorName = "";
    }
}

