/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner;

import android.graphics.Typeface;
import android.util.Log;
import net.nightwhistler.htmlspanner.FontFamily;
import net.nightwhistler.htmlspanner.FontResolver;

public class SystemFontResolver
implements FontResolver {
    private FontFamily defaultFont = new FontFamily("default", Typeface.DEFAULT);
    private FontFamily serifFont = new FontFamily("serif", Typeface.SERIF);
    private FontFamily sansSerifFont = new FontFamily("sans-serif", Typeface.SANS_SERIF);
    private FontFamily monoSpaceFont = new FontFamily("monospace", Typeface.MONOSPACE);

    @Override
    public FontFamily getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(FontFamily defaultFont) {
        this.defaultFont = defaultFont;
    }

    @Override
    public FontFamily getSansSerifFont() {
        return this.sansSerifFont;
    }

    public void setSansSerifFont(FontFamily sansSerifFont) {
        this.sansSerifFont = sansSerifFont;
    }

    @Override
    public FontFamily getSerifFont() {
        return this.serifFont;
    }

    public void setSerifFont(FontFamily serifFont) {
        this.serifFont = serifFont;
    }

    @Override
    public FontFamily getMonoSpaceFont() {
        return this.monoSpaceFont;
    }

    @Override
    public FontFamily getFont(String name) {
        if (name != null && name.length() > 0) {
            String[] parts = name.split(",(\\s)*");
            for (int i = 0; i < parts.length; ++i) {
                FontFamily fam;
                String fontName = parts[i];
                if (fontName.startsWith("\"") && fontName.endsWith("\"")) {
                    fontName = fontName.substring(1, fontName.length() - 1);
                }
                if (fontName.startsWith("'") && fontName.endsWith("'")) {
                    fontName = fontName.substring(1, fontName.length() - 1);
                }
                if ((fam = this.resolveFont(fontName)) == null) continue;
                return fam;
            }
        }
        return this.getDefaultFont();
    }

    protected FontFamily resolveFont(String name) {
        Log.d((String)"SystemFontResolver", (String)("Trying to resolve font " + name));
        if (name.equalsIgnoreCase("serif")) {
            return this.getSerifFont();
        }
        if (name.equalsIgnoreCase("sans-serif")) {
            return this.getSansSerifFont();
        }
        if (name.equalsIgnoreCase("monospace")) {
            return this.monoSpaceFont;
        }
        return null;
    }
}

