/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner;

import android.text.SpannableStringBuilder;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.nightwhistler.htmlspanner.HtmlSpanner;
import net.nightwhistler.htmlspanner.SpanCallback;
import net.nightwhistler.htmlspanner.css.CompiledRule;
import net.nightwhistler.htmlspanner.style.Style;
import org.htmlcleaner.TagNode;

public class SpanStack {
    private Stack<SpanCallback> spanItemStack = new Stack();
    private Set<CompiledRule> rules = new HashSet<CompiledRule>();
    private Map<TagNode, List<CompiledRule>> lookupCache = new HashMap<TagNode, List<CompiledRule>>();

    public void registerCompiledRule(CompiledRule rule) {
        this.rules.add(rule);
    }

    public Style getStyle(TagNode node, Style baseStyle) {
        if (!this.lookupCache.containsKey(node)) {
            Log.v((String)"SpanStack", (String)("Looking for matching CSS rules for node: <" + node.getName() + " id='" + SpanStack.option(node.getAttributeByName("id")) + "' class='" + SpanStack.option(node.getAttributeByName("class")) + "'>"));
            ArrayList<CompiledRule> matchingRules = new ArrayList<CompiledRule>();
            for (CompiledRule rule : this.rules) {
                if (!rule.matches(node)) continue;
                matchingRules.add(rule);
            }
            Log.v((String)"SpanStack", (String)("Found " + matchingRules.size() + " matching rules."));
            this.lookupCache.put(node, matchingRules);
        }
        Style result = baseStyle;
        for (CompiledRule rule : this.lookupCache.get(node)) {
            Log.v((String)"SpanStack", (String)("Applying rule " + rule));
            Style original = result;
            result = rule.applyStyle(result);
            Log.v((String)"SpanStack", (String)("Original style: " + original));
            Log.v((String)"SpanStack", (String)("Resulting style: " + result));
        }
        return result;
    }

    private static String option(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public void pushSpan(final Object span, final int start, final int end) {
        if (end > start) {
            SpanCallback callback = new SpanCallback(){

                @Override
                public void applySpan(HtmlSpanner spanner, SpannableStringBuilder builder) {
                    builder.setSpan(span, start, end, 33);
                }
            };
            this.spanItemStack.push(callback);
        } else {
            Log.d((String)"SpanStack", (String)("refusing to put span of type " + span.getClass().getSimpleName() + " and length " + (end - start)));
        }
    }

    public void pushSpan(SpanCallback callback) {
        this.spanItemStack.push(callback);
    }

    public void applySpans(HtmlSpanner spanner, SpannableStringBuilder builder) {
        while (!this.spanItemStack.isEmpty()) {
            this.spanItemStack.pop().applySpan(spanner, builder);
        }
    }
}

