/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.text.SpannableStringBuilder;
import android.util.Log;
import net.nightwhistler.htmlspanner.SpanStack;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.spans.VerticalMarginSpan;
import net.nightwhistler.htmlspanner.style.Style;
import net.nightwhistler.htmlspanner.style.StyleCallback;
import net.nightwhistler.htmlspanner.style.StyleValue;
import org.htmlcleaner.TagNode;

public class StyledTextHandler
extends TagNodeHandler {
    private Style style;

    public StyledTextHandler() {
        this.style = new Style();
    }

    public StyledTextHandler(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    @Override
    public void beforeChildren(TagNode node, SpannableStringBuilder builder, SpanStack spanStack) {
        Style useStyle = spanStack.getStyle(node, this.getStyle());
        if (builder.length() > 0 && useStyle.getDisplayStyle() == Style.DisplayStyle.BLOCK && builder.charAt(builder.length() - 1) != '\n') {
            builder.append('\n');
        }
        if (useStyle.getMarginTop() != null) {
            StyleValue styleValue = useStyle.getMarginTop();
            if (styleValue.getUnit() == StyleValue.Unit.PX) {
                if (styleValue.getIntValue() > 0 && this.appendNewLine(builder)) {
                    spanStack.pushSpan(new VerticalMarginSpan(styleValue.getIntValue()), builder.length() - 1, builder.length());
                }
            } else if (styleValue.getFloatValue() > 0.0f && this.appendNewLine(builder)) {
                spanStack.pushSpan(new VerticalMarginSpan(Float.valueOf(styleValue.getFloatValue())), builder.length() - 1, builder.length());
            }
        }
    }

    @Override
    public final void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end, SpanStack spanStack) {
        Style styleFromCSS = spanStack.getStyle(node, this.getStyle());
        this.handleTagNode(node, builder, start, end, styleFromCSS, spanStack);
    }

    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end, Style useStyle, SpanStack stack) {
        if (useStyle.getDisplayStyle() == Style.DisplayStyle.BLOCK) {
            this.appendNewLine(builder);
            if (useStyle.getMarginBottom() != null) {
                StyleValue styleValue = useStyle.getMarginBottom();
                if (styleValue.getUnit() == StyleValue.Unit.PX) {
                    if (styleValue.getIntValue() > 0) {
                        this.appendNewLine(builder);
                        stack.pushSpan(new VerticalMarginSpan(styleValue.getIntValue()), builder.length() - 1, builder.length());
                    }
                } else if (styleValue.getFloatValue() > 0.0f) {
                    this.appendNewLine(builder);
                    stack.pushSpan(new VerticalMarginSpan(Float.valueOf(styleValue.getFloatValue())), builder.length() - 1, builder.length());
                }
            }
        }
        if (builder.length() > start) {
            stack.pushSpan(new StyleCallback(this.getSpanner().getFontResolver().getDefaultFont(), useStyle, start, builder.length()));
        } else {
            Log.d((String)"StyledTextHandler", (String)("Refusing to push span of length " + (builder.length() - start)));
        }
    }
}

