/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.text.SpannableStringBuilder;
import android.util.Log;
import com.osbcp.cssparser.CSSParser;
import com.osbcp.cssparser.Rule;
import net.nightwhistler.htmlspanner.SpanStack;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.css.CSSCompiler;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;

public class StyleNodeHandler
extends TagNodeHandler {
    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end, SpanStack spanStack) {
        Object childNode;
        if (this.getSpanner().isAllowStyling() && node.getChildren().size() == 1 && (childNode = node.getChildren().get(0)) instanceof ContentNode) {
            this.parseCSSFromText(((ContentNode)childNode).getContent().toString(), spanStack);
        }
    }

    private void parseCSSFromText(String text, SpanStack spanStack) {
        try {
            for (Rule rule : CSSParser.parse((String)text)) {
                spanStack.registerCompiledRule(CSSCompiler.compile(rule, this.getSpanner()));
            }
        }
        catch (Exception e) {
            Log.e((String)"StyleNodeHandler", (String)"Unparseable CSS definition", (Throwable)e);
        }
    }

    @Override
    public boolean rendersContent() {
        return true;
    }
}

