/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.nightwhistler.htmlspanner.SpanStack;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import org.htmlcleaner.TagNode;

public class ImageHandler
extends TagNodeHandler {
    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end, SpanStack stack) {
        String src = node.getAttributeByName("src");
        builder.append((CharSequence)"\ufffc");
        Bitmap bitmap = this.loadBitmap(src);
        if (bitmap != null) {
            BitmapDrawable drawable = new BitmapDrawable(bitmap);
            drawable.setBounds(0, 0, bitmap.getWidth() - 1, bitmap.getHeight() - 1);
            stack.pushSpan(new ImageSpan((Drawable)drawable), start, builder.length());
        }
    }

    protected Bitmap loadBitmap(String url) {
        try {
            return BitmapFactory.decodeStream((InputStream)new URL(url).openStream());
        }
        catch (IOException io) {
            return null;
        }
    }
}

