/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.spans;

import android.graphics.Paint;
import android.text.TextPaint;
import android.text.style.TypefaceSpan;
import net.nightwhistler.htmlspanner.FontFamily;

public class FontFamilySpan
extends TypefaceSpan {
    private final FontFamily fontFamily;
    private boolean bold;
    private boolean italic;

    public FontFamilySpan(FontFamily type) {
        super(type.getName());
        this.fontFamily = type;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void updateDrawState(TextPaint ds) {
        this.applyCustomTypeFace((Paint)ds, this.fontFamily);
    }

    public void updateMeasureState(TextPaint paint) {
        this.applyCustomTypeFace((Paint)paint, this.fontFamily);
    }

    public void updateMeasureState(Paint paint) {
        this.applyCustomTypeFace(paint, this.fontFamily);
    }

    private void applyCustomTypeFace(Paint paint, FontFamily tf) {
        paint.setAntiAlias(true);
        paint.setTypeface(tf.getDefaultTypeface());
        if (this.bold) {
            if (tf.isFakeBold()) {
                paint.setFakeBoldText(true);
            } else {
                paint.setTypeface(tf.getBoldTypeface());
            }
        }
        if (this.italic) {
            if (tf.isFakeItalic()) {
                paint.setTextSkewX(-0.25f);
            } else {
                paint.setTypeface(tf.getItalicTypeface());
            }
        }
        if (this.bold && this.italic && tf.getBoldItalicTypeface() != null) {
            paint.setTypeface(tf.getBoldItalicTypeface());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{\n");
        builder.append("  font-family: " + this.fontFamily.getName() + "\n");
        builder.append("  bold: " + this.isBold() + "\n");
        builder.append("  italic: " + this.isItalic() + "\n");
        builder.append("}");
        return builder.toString();
    }
}

