/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.nightwhistler.htmlspanner.FontFamily;
import net.nightwhistler.htmlspanner.FontResolver;
import net.nightwhistler.htmlspanner.SpanStack;
import net.nightwhistler.htmlspanner.SystemFontResolver;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.TextUtil;
import net.nightwhistler.htmlspanner.exception.ParsingCancelledException;
import net.nightwhistler.htmlspanner.handlers.FontHandler;
import net.nightwhistler.htmlspanner.handlers.HeaderHandler;
import net.nightwhistler.htmlspanner.handlers.ImageHandler;
import net.nightwhistler.htmlspanner.handlers.LinkHandler;
import net.nightwhistler.htmlspanner.handlers.ListItemHandler;
import net.nightwhistler.htmlspanner.handlers.MonoSpaceHandler;
import net.nightwhistler.htmlspanner.handlers.NewLineHandler;
import net.nightwhistler.htmlspanner.handlers.PreHandler;
import net.nightwhistler.htmlspanner.handlers.StyleNodeHandler;
import net.nightwhistler.htmlspanner.handlers.StyledTextHandler;
import net.nightwhistler.htmlspanner.handlers.SubScriptHandler;
import net.nightwhistler.htmlspanner.handlers.SuperScriptHandler;
import net.nightwhistler.htmlspanner.handlers.attributes.AlignmentAttributeHandler;
import net.nightwhistler.htmlspanner.handlers.attributes.BorderAttributeHandler;
import net.nightwhistler.htmlspanner.handlers.attributes.StyleAttributeHandler;
import net.nightwhistler.htmlspanner.style.Style;
import net.nightwhistler.htmlspanner.style.StyleValue;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

public class HtmlSpanner {
    public static final int HORIZONTAL_EM_WIDTH = 10;
    private Map<String, TagNodeHandler> handlers;
    private boolean stripExtraWhiteSpace = false;
    private HtmlCleaner htmlCleaner;
    private FontResolver fontResolver;
    private boolean allowStyling = true;
    private boolean useColoursFromStyle = true;

    public HtmlSpanner() {
        this(HtmlSpanner.createHtmlCleaner(), new SystemFontResolver());
    }

    public HtmlSpanner(HtmlCleaner cleaner, FontResolver fontResolver) {
        this.htmlCleaner = cleaner;
        this.fontResolver = fontResolver;
        this.handlers = new HashMap<String, TagNodeHandler>();
        this.registerBuiltInHandlers();
    }

    public FontResolver getFontResolver() {
        return this.fontResolver;
    }

    public void setFontResolver(FontResolver fontResolver) {
        this.fontResolver = fontResolver;
    }

    public FontFamily getFont(String name) {
        return this.fontResolver.getFont(name);
    }

    public void setStripExtraWhiteSpace(boolean stripExtraWhiteSpace) {
        this.stripExtraWhiteSpace = stripExtraWhiteSpace;
    }

    public boolean isStripExtraWhiteSpace() {
        return this.stripExtraWhiteSpace;
    }

    public boolean isAllowStyling() {
        return this.allowStyling;
    }

    public void setAllowStyling(boolean value) {
        this.allowStyling = value;
    }

    public void setUseColoursFromStyle(boolean value) {
        this.useColoursFromStyle = value;
    }

    public boolean isUseColoursFromStyle() {
        return this.useColoursFromStyle;
    }

    public void registerHandler(String tagName, TagNodeHandler handler) {
        this.handlers.put(tagName, handler);
        handler.setSpanner(this);
    }

    public void unregisterHandler(String tagName) {
        this.handlers.remove(tagName);
    }

    public Spannable fromHtml(String html) {
        return this.fromTagNode(this.htmlCleaner.clean(html), null);
    }

    public Spannable fromHtml(String html, CancellationCallback cancellationCallback) {
        return this.fromTagNode(this.htmlCleaner.clean(html), cancellationCallback);
    }

    public Spannable fromHtml(Reader reader) throws IOException {
        return this.fromTagNode(this.htmlCleaner.clean(reader), null);
    }

    public Spannable fromHtml(Reader reader, CancellationCallback cancellationCallback) throws IOException {
        return this.fromTagNode(this.htmlCleaner.clean(reader), cancellationCallback);
    }

    public Spannable fromHtml(InputStream inputStream) throws IOException {
        return this.fromTagNode(this.htmlCleaner.clean(inputStream), null);
    }

    public Spannable fromHtml(InputStream inputStream, CancellationCallback cancellationCallback) throws IOException {
        return this.fromTagNode(this.htmlCleaner.clean(inputStream), cancellationCallback);
    }

    public TagNodeHandler getHandlerFor(String tagName) {
        return this.handlers.get(tagName);
    }

    public Spannable fromTagNode(TagNode node, CancellationCallback cancellationCallback) {
        SpannableStringBuilder result = new SpannableStringBuilder();
        SpanStack stack = new SpanStack();
        this.applySpan(result, node, stack, cancellationCallback);
        stack.applySpans(this, result);
        return result;
    }

    private static HtmlCleaner createHtmlCleaner() {
        HtmlCleaner result = new HtmlCleaner();
        CleanerProperties cleanerProperties = result.getProperties();
        cleanerProperties.setAdvancedXmlEscape(true);
        cleanerProperties.setOmitXmlDeclaration(true);
        cleanerProperties.setOmitDoctypeDeclaration(false);
        cleanerProperties.setTranslateSpecialEntities(true);
        cleanerProperties.setTransResCharsToNCR(true);
        cleanerProperties.setRecognizeUnicodeChars(true);
        cleanerProperties.setIgnoreQuestAndExclam(true);
        cleanerProperties.setUseEmptyElementTags(false);
        cleanerProperties.setPruneTags("script,title");
        return result;
    }

    private void checkForCancellation(CancellationCallback cancellationCallback) {
        if (cancellationCallback != null && cancellationCallback.isCancelled()) {
            throw new ParsingCancelledException();
        }
    }

    private void handleContent(SpannableStringBuilder builder, Object node, SpanStack stack, CancellationCallback cancellationCallback) {
        this.checkForCancellation(cancellationCallback);
        ContentNode contentNode = (ContentNode)node;
        String text = TextUtil.replaceHtmlEntities(contentNode.getContent().toString(), false);
        if (this.isStripExtraWhiteSpace()) {
            text = text.replace('\u00a0', ' ');
        }
        if (text.trim().length() > 0) {
            builder.append((CharSequence)text);
        }
    }

    private void applySpan(SpannableStringBuilder builder, TagNode node, SpanStack stack, CancellationCallback cancellationCallback) {
        this.checkForCancellation(cancellationCallback);
        TagNodeHandler handler = this.handlers.get(node.getName());
        if (handler == null) {
            handler = new StyledTextHandler();
            handler.setSpanner(this);
        }
        int lengthBefore = builder.length();
        handler.beforeChildren(node, builder, stack);
        if (!handler.rendersContent()) {
            for (Object childNode : node.getChildren()) {
                if (childNode instanceof ContentNode) {
                    this.handleContent(builder, childNode, stack, cancellationCallback);
                    continue;
                }
                if (!(childNode instanceof TagNode)) continue;
                this.applySpan(builder, (TagNode)childNode, stack, cancellationCallback);
            }
        }
        int lengthAfter = builder.length();
        handler.handleTagNode(node, builder, lengthBefore, lengthAfter, stack);
    }

    private static StyledTextHandler wrap(StyledTextHandler handler) {
        return new StyleAttributeHandler(new AlignmentAttributeHandler(handler));
    }

    private void registerBuiltInHandlers() {
        StyledTextHandler italicHandler = new StyledTextHandler(new Style().setFontStyle(Style.FontStyle.ITALIC));
        this.registerHandler("i", italicHandler);
        this.registerHandler("em", italicHandler);
        this.registerHandler("cite", italicHandler);
        this.registerHandler("dfn", italicHandler);
        StyledTextHandler boldHandler = new StyledTextHandler(new Style().setFontWeight(Style.FontWeight.BOLD));
        this.registerHandler("b", boldHandler);
        this.registerHandler("strong", boldHandler);
        StyledTextHandler marginHandler = new StyledTextHandler(new Style().setMarginLeft(new StyleValue(2.0f, StyleValue.Unit.EM)));
        this.registerHandler("blockquote", marginHandler);
        this.registerHandler("ul", marginHandler);
        this.registerHandler("ol", marginHandler);
        StyledTextHandler monSpaceHandler = HtmlSpanner.wrap(new MonoSpaceHandler());
        this.registerHandler("tt", monSpaceHandler);
        this.registerHandler("code", monSpaceHandler);
        this.registerHandler("style", new StyleNodeHandler());
        StyledTextHandler inlineAlignment = HtmlSpanner.wrap(new StyledTextHandler());
        NewLineHandler brHandler = new NewLineHandler(1, inlineAlignment);
        this.registerHandler("br", brHandler);
        Style paragraphStyle = new Style().setDisplayStyle(Style.DisplayStyle.BLOCK).setMarginBottom(new StyleValue(1.0f, StyleValue.Unit.EM));
        BorderAttributeHandler pHandler = new BorderAttributeHandler(HtmlSpanner.wrap(new StyledTextHandler(paragraphStyle)));
        this.registerHandler("p", pHandler);
        this.registerHandler("div", pHandler);
        this.registerHandler("h1", HtmlSpanner.wrap(new HeaderHandler(1.5f, 0.5f)));
        this.registerHandler("h2", HtmlSpanner.wrap(new HeaderHandler(1.4f, 0.6f)));
        this.registerHandler("h3", HtmlSpanner.wrap(new HeaderHandler(1.3f, 0.7f)));
        this.registerHandler("h4", HtmlSpanner.wrap(new HeaderHandler(1.2f, 0.8f)));
        this.registerHandler("h5", HtmlSpanner.wrap(new HeaderHandler(1.1f, 0.9f)));
        this.registerHandler("h6", HtmlSpanner.wrap(new HeaderHandler(1.0f, 1.0f)));
        PreHandler preHandler = new PreHandler();
        this.registerHandler("pre", preHandler);
        StyledTextHandler bigHandler = new StyledTextHandler(new Style().setFontSize(new StyleValue(1.25f, StyleValue.Unit.EM)));
        this.registerHandler("big", bigHandler);
        StyledTextHandler smallHandler = new StyledTextHandler(new Style().setFontSize(new StyleValue(0.8f, StyleValue.Unit.EM)));
        this.registerHandler("small", smallHandler);
        SubScriptHandler subHandler = new SubScriptHandler();
        this.registerHandler("sub", subHandler);
        SuperScriptHandler superHandler = new SuperScriptHandler();
        this.registerHandler("sup", superHandler);
        StyledTextHandler centerHandler = new StyledTextHandler(new Style().setTextAlignment(Style.TextAlignment.CENTER));
        this.registerHandler("center", centerHandler);
        this.registerHandler("li", new ListItemHandler());
        this.registerHandler("a", new LinkHandler());
        this.registerHandler("img", new ImageHandler());
        this.registerHandler("font", new FontHandler());
        Style spanStyle = new Style().setDisplayStyle(Style.DisplayStyle.INLINE);
        BorderAttributeHandler spanHandler = new BorderAttributeHandler(HtmlSpanner.wrap(new StyledTextHandler(spanStyle)));
        this.registerHandler("span", spanHandler);
    }

    public static interface CancellationCallback {
        public boolean isCancelled();
    }
}

