/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;

public class ListItemSpan
implements LeadingMarginSpan {
    private final int mNumber;
    private static final int BULLET_RADIUS = 3;
    private static final int NUMBER_RADIUS = 5;
    public static final int STANDARD_GAP_WIDTH = 2;

    public ListItemSpan() {
        this.mNumber = -1;
    }

    public ListItemSpan(int number) {
        this.mNumber = number;
    }

    public int getLeadingMargin(boolean first) {
        if (this.mNumber != -1) {
            return 12;
        }
        return 8;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
        if (((Spanned)text).getSpanStart((Object)this) == start) {
            Paint.Style style = p.getStyle();
            p.setStyle(Paint.Style.FILL);
            if (this.mNumber != -1) {
                c.drawText(this.mNumber + ".", (float)(x + dir), (float)baseline, p);
            } else {
                c.drawText("\u2022", (float)(x + dir), (float)baseline, p);
            }
            p.setStyle(style);
        }
    }
}

