/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.text.SpannableStringBuilder;
import android.text.style.RelativeSizeSpan;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.spans.FontFamilySpan;
import org.htmlcleaner.TagNode;

public class HeaderHandler
extends TagNodeHandler {
    private float size;

    public HeaderHandler(float size) {
        this.size = size;
    }

    @Override
    public void beforeChildren(TagNode node, SpannableStringBuilder builder) {
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) != '\n') {
            builder.append((CharSequence)"\n");
        }
    }

    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end) {
        FontFamilySpan boldSpan;
        builder.setSpan((Object)new RelativeSizeSpan(this.size), start, end, 33);
        FontFamilySpan originalSpan = this.getFontFamilySpan(builder, start, end);
        if (originalSpan == null) {
            boldSpan = new FontFamilySpan(this.getSpanner().getDefaultFont());
        } else {
            boldSpan = new FontFamilySpan(originalSpan.getFontFamily());
            boldSpan.setItalic(originalSpan.isItalic());
        }
        boldSpan.setBold(true);
        builder.setSpan((Object)boldSpan, start, end, 33);
        this.appendNewLine(builder);
        this.appendNewLine(builder);
    }
}

