/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.text.SpannableStringBuilder;
import net.nightwhistler.htmlspanner.HtmlSpanner;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.spans.AlignNormalSpan;
import net.nightwhistler.htmlspanner.spans.AlignOppositeSpan;
import net.nightwhistler.htmlspanner.spans.CenterSpan;
import org.htmlcleaner.TagNode;

public class AlignmentHandler
extends TagNodeHandler {
    private TagNodeHandler wrappedHandler;

    public AlignmentHandler() {
    }

    public AlignmentHandler(TagNodeHandler wrapHandler) {
        this.wrappedHandler = wrapHandler;
    }

    @Override
    public void setSpanner(HtmlSpanner spanner) {
        super.setSpanner(spanner);
        if (this.wrappedHandler != null) {
            this.wrappedHandler.setSpanner(spanner);
        }
    }

    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end) {
        String align = node.getAttributeByName("align");
        Object span = null;
        if ("right".equalsIgnoreCase(align)) {
            span = new AlignOppositeSpan();
        } else if ("center".equalsIgnoreCase(align)) {
            span = new CenterSpan();
        } else if ("left".equalsIgnoreCase(align)) {
            span = new AlignNormalSpan();
        }
        if (span != null) {
            builder.setSpan(span, start, end, 33);
        }
        if (this.wrappedHandler != null) {
            this.wrappedHandler.handleTagNode(node, builder, start, end);
        }
    }
}

