/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner;

import android.graphics.Typeface;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.nightwhistler.htmlspanner.FontFamily;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.TextUtil;
import net.nightwhistler.htmlspanner.handlers.AlignmentHandler;
import net.nightwhistler.htmlspanner.handlers.BoldHandler;
import net.nightwhistler.htmlspanner.handlers.CenterHandler;
import net.nightwhistler.htmlspanner.handlers.FontHandler;
import net.nightwhistler.htmlspanner.handlers.HeaderHandler;
import net.nightwhistler.htmlspanner.handlers.ImageHandler;
import net.nightwhistler.htmlspanner.handlers.ItalicHandler;
import net.nightwhistler.htmlspanner.handlers.LinkHandler;
import net.nightwhistler.htmlspanner.handlers.ListItemHandler;
import net.nightwhistler.htmlspanner.handlers.MarginHandler;
import net.nightwhistler.htmlspanner.handlers.MonoSpaceHandler;
import net.nightwhistler.htmlspanner.handlers.NewLineHandler;
import net.nightwhistler.htmlspanner.handlers.PreHandler;
import net.nightwhistler.htmlspanner.handlers.RelativeSizeHandler;
import net.nightwhistler.htmlspanner.handlers.SubScriptHandler;
import net.nightwhistler.htmlspanner.handlers.SuperScriptHandler;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;

public class HtmlSpanner {
    private Map<String, TagNodeHandler> handlers;
    private boolean stripExtraWhiteSpace = false;
    private HtmlCleaner htmlCleaner;
    private FontFamily defaultFont;
    private FontFamily serifFont;
    private FontFamily sansSerifFont;

    public HtmlSpanner() {
        this(HtmlSpanner.createHtmlCleaner());
    }

    public HtmlSpanner(HtmlCleaner cleaner) {
        this.htmlCleaner = cleaner;
        this.handlers = new HashMap<String, TagNodeHandler>();
        this.defaultFont = new FontFamily("default", Typeface.DEFAULT);
        this.serifFont = new FontFamily("serif", Typeface.SERIF);
        this.sansSerifFont = new FontFamily("sans-serif", Typeface.SANS_SERIF);
        this.registerBuiltInHandlers();
    }

    public FontFamily getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(FontFamily defaultFont) {
        this.defaultFont = defaultFont;
    }

    public FontFamily getSansSerifFont() {
        return this.sansSerifFont;
    }

    public void setSansSerifFont(FontFamily sansSerifFont) {
        this.sansSerifFont = sansSerifFont;
    }

    public FontFamily getSerifFont() {
        return this.serifFont;
    }

    public void setSerifFont(FontFamily serifFont) {
        this.serifFont = serifFont;
    }

    public void setStripExtraWhiteSpace(boolean stripExtraWhiteSpace) {
        this.stripExtraWhiteSpace = stripExtraWhiteSpace;
    }

    public boolean isStripExtraWhiteSpace() {
        return this.stripExtraWhiteSpace;
    }

    public void registerHandler(String tagName, TagNodeHandler handler) {
        this.handlers.put(tagName, handler);
        handler.setSpanner(this);
    }

    public void unregisterHandler(String tagName) {
        this.handlers.remove(tagName);
    }

    public Spannable fromHtml(String html) {
        return this.fromTagNode(this.htmlCleaner.clean(html));
    }

    public Spannable fromHtml(Reader reader) throws IOException {
        return this.fromTagNode(this.htmlCleaner.clean(reader));
    }

    public Spannable fromHtml(InputStream inputStream) throws IOException {
        return this.fromTagNode(this.htmlCleaner.clean(inputStream));
    }

    public TagNodeHandler getHandlerFor(String tagName) {
        return this.handlers.get(tagName);
    }

    public Spannable fromTagNode(TagNode node) {
        SpannableStringBuilder result = new SpannableStringBuilder();
        this.handleContent(result, node);
        return result;
    }

    private static HtmlCleaner createHtmlCleaner() {
        HtmlCleaner result = new HtmlCleaner();
        CleanerProperties cleanerProperties = result.getProperties();
        cleanerProperties.setAdvancedXmlEscape(true);
        cleanerProperties.setOmitXmlDeclaration(true);
        cleanerProperties.setOmitDoctypeDeclaration(false);
        cleanerProperties.setTranslateSpecialEntities(true);
        cleanerProperties.setTransResCharsToNCR(true);
        cleanerProperties.setRecognizeUnicodeChars(true);
        cleanerProperties.setIgnoreQuestAndExclam(true);
        cleanerProperties.setUseEmptyElementTags(false);
        cleanerProperties.setPruneTags("script,style,title");
        return result;
    }

    private void handleContent(SpannableStringBuilder builder, Object node) {
        if (node instanceof TagNode) {
            TagNode tagNode = (TagNode)node;
            TagNodeHandler handler = this.handlers.get(tagNode.getName());
            int lengthBefore = builder.length();
            if (handler != null) {
                handler.beforeChildren(tagNode, builder);
            }
            if (handler == null || !handler.rendersContent()) {
                for (Object childNode : tagNode.getChildren()) {
                    this.handleContent(builder, childNode);
                }
            }
            int lengthAfter = builder.length();
            if (handler != null) {
                handler.handleTagNode(tagNode, builder, lengthBefore, lengthAfter);
            }
        } else if (node instanceof ContentNode) {
            this.handleContentNode(builder, (ContentNode)node);
        }
    }

    private void handleContentNode(SpannableStringBuilder builder, ContentNode contentNode) {
        char lastChar;
        if (builder.length() > 0 && (lastChar = builder.charAt(builder.length() - 1)) != ' ' && lastChar != '\n') {
            builder.append(' ');
        }
        String text = TextUtil.replaceHtmlEntities(contentNode.getContent().toString(), false);
        if (this.isStripExtraWhiteSpace()) {
            text = text.replace('\u00a0', ' ');
        }
        text = text.trim();
        builder.append((CharSequence)text);
    }

    private void registerBuiltInHandlers() {
        ItalicHandler italicHandler = new ItalicHandler();
        this.registerHandler("i", italicHandler);
        this.registerHandler("strong", italicHandler);
        this.registerHandler("cite", italicHandler);
        this.registerHandler("dfn", italicHandler);
        BoldHandler boldHandler = new BoldHandler();
        this.registerHandler("b", boldHandler);
        this.registerHandler("em", boldHandler);
        MarginHandler marginHandler = new MarginHandler();
        this.registerHandler("blockquote", marginHandler);
        this.registerHandler("ul", marginHandler);
        this.registerHandler("ol", marginHandler);
        NewLineHandler brHandler = new NewLineHandler(1);
        this.registerHandler("br", brHandler);
        NewLineHandler pHandler = new NewLineHandler(2);
        this.registerHandler("p", new AlignmentHandler(pHandler));
        this.registerHandler("div", new AlignmentHandler(pHandler));
        this.registerHandler("h1", new HeaderHandler(1.5f));
        this.registerHandler("h2", new HeaderHandler(1.4f));
        this.registerHandler("h3", new HeaderHandler(1.3f));
        this.registerHandler("h4", new HeaderHandler(1.2f));
        this.registerHandler("h5", new HeaderHandler(1.1f));
        this.registerHandler("h6", new HeaderHandler(1.0f));
        MonoSpaceHandler monSpaceHandler = new MonoSpaceHandler();
        this.registerHandler("tt", monSpaceHandler);
        PreHandler preHandler = new PreHandler();
        this.registerHandler("pre", preHandler);
        RelativeSizeHandler bigHandler = new RelativeSizeHandler(1.25f);
        this.registerHandler("big", bigHandler);
        RelativeSizeHandler smallHandler = new RelativeSizeHandler(0.8f);
        this.registerHandler("small", smallHandler);
        SubScriptHandler subHandler = new SubScriptHandler();
        this.registerHandler("sub", subHandler);
        SuperScriptHandler superHandler = new SuperScriptHandler();
        this.registerHandler("sup", superHandler);
        CenterHandler centerHandler = new CenterHandler();
        this.registerHandler("center", centerHandler);
        this.registerHandler("li", new ListItemHandler());
        this.registerHandler("a", new LinkHandler());
        this.registerHandler("img", new ImageHandler());
        this.registerHandler("font", new FontHandler());
    }
}

