/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.dispatcher;

import com.github.leanframeworks.minibus.api.Event;
import com.github.leanframeworks.minibus.api.EventFilter;
import com.github.leanframeworks.minibus.api.EventHandler;
import com.github.leanframeworks.minibus.api.ExceptionHandler;
import com.github.leanframeworks.minibus.base.dispatcher.AbstractSerialDispatcher;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentThreadDispatcher
extends AbstractSerialDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentThreadDispatcher.class);
    private final NestedDispatchStrategy nestedDispatchStrategy;

    public CurrentThreadDispatcher(NestedDispatchStrategy nestedDispatchStrategy) {
        this.nestedDispatchStrategy = nestedDispatchStrategy;
    }

    public NestedDispatchStrategy getNestedDispatchStrategy() {
        return this.nestedDispatchStrategy;
    }

    @Override
    public void dispatch(Event<Object> event, Map<EventHandler<Object>, EventFilter<Object>> eventHandlers, Collection<EventHandler<Object>> undeliveredEventHandlers, Collection<ExceptionHandler> exceptionHandlers) {
        if (this.getNestedDispatchCount() > 0) {
            NestedDispatchStrategy nestedDispatchStrategy = this.getNestedDispatchStrategy();
            switch (nestedDispatchStrategy) {
                case PROCESS_IMMEDIATELY: {
                    this.processEvent(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers);
                    this.processQueue();
                    break;
                }
                case QUEUE: {
                    this.queueEvent(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers);
                    break;
                }
                default: {
                    LOGGER.error("Unsupported nested dispatch strategy: {}", (Object)nestedDispatchStrategy);
                    break;
                }
            }
        } else {
            this.processEvent(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers);
            this.processQueue();
        }
    }

    @Override
    public void dispose() {
    }

    public static enum NestedDispatchStrategy {
        PROCESS_IMMEDIATELY,
        QUEUE;

    }
}

