/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.dispatcher;

import com.github.leanframeworks.minibus.api.Event;
import com.github.leanframeworks.minibus.api.EventFilter;
import com.github.leanframeworks.minibus.api.EventHandler;
import com.github.leanframeworks.minibus.api.ExceptionHandler;
import com.github.leanframeworks.minibus.base.dispatcher.AbstractSerialDispatcher;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUIThreadDispatcher
extends AbstractSerialDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUIThreadDispatcher.class);
    private final NestedDispatchStrategy nestedDispatchStrategy;

    public AbstractUIThreadDispatcher(NestedDispatchStrategy nestedDispatchStrategy) {
        this.nestedDispatchStrategy = nestedDispatchStrategy;
    }

    public NestedDispatchStrategy getNestedDispatchStrategy() {
        return this.nestedDispatchStrategy;
    }

    @Override
    public void dispatch(Event<Object> event, Map<EventHandler<Object>, EventFilter<Object>> eventHandlers, Collection<EventHandler<Object>> undeliveredEventHandlers, Collection<ExceptionHandler> exceptionHandlers) {
        if (this.isUIThread()) {
            if (this.getNestedDispatchCount() > 0) {
                NestedDispatchStrategy nestedDispatchStrategy = this.getNestedDispatchStrategy();
                switch (nestedDispatchStrategy) {
                    case PROCESS_IMMEDIATELY: {
                        this.processEvent(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers);
                        this.processQueue();
                        break;
                    }
                    case QUEUE: {
                        this.queueEvent(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers);
                        break;
                    }
                    case RESCHEDULE: {
                        this.runLaterOnUIThread(() -> {
                            this.processEvent(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers);
                            this.processQueue();
                        });
                        break;
                    }
                    default: {
                        LOGGER.error("Unsupported nested dispatch strategy: {}", (Object)nestedDispatchStrategy);
                        break;
                    }
                }
            } else {
                this.processEvent(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers);
                this.processQueue();
            }
        } else {
            this.runLaterOnUIThread(() -> this.dispatch(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers));
        }
    }

    protected abstract boolean isUIThread();

    protected abstract void runLaterOnUIThread(Runnable var1);

    public static enum NestedDispatchStrategy {
        PROCESS_IMMEDIATELY,
        QUEUE,
        RESCHEDULE;

    }
}

