/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.dispatcher;

import com.github.leanframeworks.minibus.api.Event;
import com.github.leanframeworks.minibus.api.EventFilter;
import com.github.leanframeworks.minibus.api.EventHandler;
import com.github.leanframeworks.minibus.api.ExceptionHandler;
import com.github.leanframeworks.minibus.base.dispatcher.AbstractDispatcher;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialDispatcher
extends AbstractDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerialDispatcher.class);
    private final Queue<QueueEntry> queuedEvents = new LinkedList<QueueEntry>();
    private int nestedDispatchCount = 0;

    protected final int getNestedDispatchCount() {
        return this.nestedDispatchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processEvent(Event<Object> event, Map<EventHandler<Object>, EventFilter<Object>> eventHandlers, Collection<EventHandler<Object>> undeliveredEventHandlers, Collection<ExceptionHandler> exceptionHandlers) {
        LOGGER.debug("Dispatching event '{}'", event);
        ++this.nestedDispatchCount;
        try {
            boolean delivered = false;
            for (Map.Entry<EventHandler<Object>, EventFilter<Object>> entry : eventHandlers.entrySet()) {
                delivered = this.processEventThroughFilterAndHandler(event, entry.getValue(), entry.getKey(), exceptionHandlers);
            }
            if (!delivered) {
                this.processUndeliveredEvent(event, undeliveredEventHandlers, exceptionHandlers);
            }
        }
        finally {
            --this.nestedDispatchCount;
        }
    }

    protected final void queueEvent(Event<Object> event, Map<EventHandler<Object>, EventFilter<Object>> eventHandlers, Collection<EventHandler<Object>> undeliveredEventHandlers, Collection<ExceptionHandler> exceptionHandlers) {
        this.queuedEvents.offer(new QueueEntry(event, eventHandlers, undeliveredEventHandlers, exceptionHandlers));
    }

    protected final void processQueue() {
        while (!this.queuedEvents.isEmpty()) {
            QueueEntry entry = this.queuedEvents.poll();
            this.processEvent(entry.getEvent(), entry.getEventHandlers(), entry.getUndeliveredEventHandlers(), entry.getExceptionHandlers());
        }
    }

    private static class QueueEntry {
        private final Event<Object> event;
        private final Map<EventHandler<Object>, EventFilter<Object>> eventHandlers;
        private final Collection<EventHandler<Object>> undeliveredEventHandlers;
        private final Collection<ExceptionHandler> exceptionHandlers;

        public QueueEntry(Event<Object> event, Map<EventHandler<Object>, EventFilter<Object>> eventHandlers, Collection<EventHandler<Object>> undeliveredEventHandlers, Collection<ExceptionHandler> exceptionHandlers) {
            this.event = event;
            this.eventHandlers = eventHandlers;
            this.undeliveredEventHandlers = undeliveredEventHandlers;
            this.exceptionHandlers = exceptionHandlers;
        }

        public Event<Object> getEvent() {
            return this.event;
        }

        public Map<EventHandler<Object>, EventFilter<Object>> getEventHandlers() {
            return this.eventHandlers;
        }

        public Collection<EventHandler<Object>> getUndeliveredEventHandlers() {
            return this.undeliveredEventHandlers;
        }

        public Collection<ExceptionHandler> getExceptionHandlers() {
            return this.exceptionHandlers;
        }
    }
}

