/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.channel;

import com.github.leanframeworks.minibus.api.Channel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class SimpleChannel
implements Channel {
    private final String name;
    private final Collection<Channel> subChannels;

    public SimpleChannel() {
        this(null, (Collection<Channel>)null);
    }

    public SimpleChannel(Channel ... subChannels) {
        this(null, Arrays.asList(subChannels));
    }

    public SimpleChannel(Collection<Channel> subChannels) {
        this(null, subChannels);
    }

    public SimpleChannel(String name) {
        this(name, (Collection<Channel>)null);
    }

    public SimpleChannel(String name, Channel ... subChannels) {
        this(name, Arrays.asList(subChannels));
    }

    public SimpleChannel(String name, Collection<Channel> subChannels) {
        this.name = name == null ? Channel.super.getName() : name;
        this.subChannels = subChannels == null ? Collections.emptySet() : new HashSet<Channel>(subChannels);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Collection<Channel> getSubChannels() {
        return this.subChannels;
    }

    public void addSubChannel(Channel channel) {
        this.subChannels.add(channel);
    }

    public void removeSubChannel(Channel channel) {
        this.subChannels.remove(channel);
    }

    @Override
    public boolean flowsInto(Channel channel) {
        boolean result = false;
        if (this.equals(channel)) {
            result = true;
        } else {
            for (Channel subChannel : this.subChannels) {
                if (!subChannel.equals(channel) && !subChannel.flowsInto(channel)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[" + this.name + ']';
    }
}

