/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.bus;

import com.github.leanframeworks.minibus.api.Channel;
import com.github.leanframeworks.minibus.api.Event;
import com.github.leanframeworks.minibus.api.EventBus;
import com.github.leanframeworks.minibus.api.EventFilter;
import com.github.leanframeworks.minibus.api.EventHandler;
import com.github.leanframeworks.minibus.api.ExceptionHandler;
import com.github.leanframeworks.minibus.api.Topic;
import com.github.leanframeworks.minibus.base.channel.BroadcastChannel;
import com.github.leanframeworks.minibus.base.channel.SimpleChannel;
import com.github.leanframeworks.minibus.base.filter.ChannelFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventBus
implements EventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventBus.class);
    protected final List<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();
    protected final List<EventHandler<Object>> undeliveredEventHandlers = new ArrayList<EventHandler<Object>>();
    protected final Map<Topic<?>, Collection<SubscriptionEntry<?>>> topicToSubscription = new HashMap();
    protected final Map<Integer, SubscriptionEntry<?>> idToSubscription = new HashMap();
    private int lastId = -1;

    @Override
    public void addExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandlers.add(handler);
    }

    @Override
    public void removeExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandlers.remove(handler);
    }

    @Override
    public void addUndeliveredEventHandler(EventHandler<Object> handler) {
        this.undeliveredEventHandlers.add(handler);
    }

    @Override
    public void removeUndeliveredEventHandler(EventHandler<Object> handler) {
        this.undeliveredEventHandlers.remove(handler);
    }

    protected Channel createDefaultChannelForHandler(EventHandler<?> handler) {
        return new SimpleChannel("Channel:" + handler.getClass().getCanonicalName() + "@" + Integer.toHexString(System.identityHashCode(handler)));
    }

    public final <C> int subscribe(Topic<C> topic, EventHandler<? super C> handler) {
        return this.subscribe(topic, null, null, handler);
    }

    public final <C> int subscribe(Topic<C> topic, Channel channel, EventHandler<? super C> handler) {
        return this.subscribe(topic, channel, null, handler);
    }

    public final <C> int subscribe(Topic<C> topic, EventFilter<? super C> filter, EventHandler<? super C> handler) {
        return this.subscribe(topic, null, filter, handler);
    }

    @Override
    public final <C> int subscribe(Topic<C> topic, Channel channel, EventFilter<? super C> filter, EventHandler<? super C> handler) {
        int resultId;
        if (topic == null || handler == null) {
            LOGGER.error("Cannot subscribe with no topic ({}) or no handler ({})", topic, handler);
            resultId = -1;
        } else {
            resultId = ++this.lastId;
            Collection registry = this.topicToSubscription.computeIfAbsent(topic, k -> new HashSet());
            Channel effectiveChannel = channel == null ? this.createDefaultChannelForHandler(handler) : channel;
            EventFilter<Object> effectiveFilter = filter == null ? new ChannelFilter(effectiveChannel) : filter.and(new ChannelFilter(effectiveChannel));
            SubscriptionEntry<? super C> entry = new SubscriptionEntry<C>(resultId, topic, effectiveFilter, handler);
            registry.add(entry);
            this.idToSubscription.put(resultId, entry);
        }
        return resultId;
    }

    @Override
    public void unsubscribe(int id) {
        assert (this.idToSubscription.containsKey(id)) : MessageFormat.format("Unknown registry entry for ID {0}", id);
        this.idToSubscription.remove(id);
    }

    public final void publish(Topic<Void> topic) {
        this.publish(topic, null);
    }

    public final <C> void publish(Topic<C> topic, C content) {
        this.publish(topic, BroadcastChannel.getInstance(), content);
    }

    @Override
    public final <C> void publish(Topic<C> topic, Channel channel, C content) {
        this.publish(new Event<C>(topic, channel, content));
    }

    protected abstract <C> void publish(Event<C> var1);

    @Override
    public void dispose() {
        this.exceptionHandlers.clear();
        this.undeliveredEventHandlers.clear();
        this.topicToSubscription.clear();
        this.idToSubscription.clear();
        this.lastId = -1;
    }

    protected class SubscriptionEntry<C> {
        private final int id;
        private final Topic<C> topic;
        private final EventFilter<? super C> filter;
        private final EventHandler<? super C> handler;

        public SubscriptionEntry(int id, Topic<C> topic, EventFilter<? super C> filter, EventHandler<? super C> handler) {
            this.id = id;
            this.topic = topic;
            this.filter = filter;
            this.handler = handler;
        }

        public int getId() {
            return this.id;
        }

        public Topic<C> getTopic() {
            return this.topic;
        }

        public EventFilter<? super C> getFilter() {
            return this.filter;
        }

        public EventHandler<? super C> getHandler() {
            return this.handler;
        }
    }
}

