/*
 * Decompiled with CFR 0.152.
 */
package com.github.leandroborgesferreira.loadingbutton.animatedDrawables;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.github.leandroborgesferreira.loadingbutton.ExtensionsKt;
import com.github.leandroborgesferreira.loadingbutton.animatedDrawables.ProgressType;
import com.github.leandroborgesferreira.loadingbutton.customViews.ProgressButton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000600H\u0002J\b\u00101\u001a\u00020\bH\u0016J\b\u00102\u001a\u00020\u0018H\u0016J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\bH\u0016J\u0012\u00105\u001a\u00020+2\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u000e\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020\bJ\b\u0010:\u001a\u00020+H\u0016J\b\u0010;\u001a\u00020+H\u0016J\u0010\u0010<\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010=\u001a\u00020+H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/github/leandroborgesferreira/loadingbutton/animatedDrawables/CircularProgressAnimatedDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Animatable;", "progressButton", "Lcom/github/leandroborgesferreira/loadingbutton/customViews/ProgressButton;", "borderWidth", "", "arcColor", "", "progressType", "Lcom/github/leandroborgesferreira/loadingbutton/animatedDrawables/ProgressType;", "(Lcom/github/leandroborgesferreira/loadingbutton/customViews/ProgressButton;FILcom/github/leandroborgesferreira/loadingbutton/animatedDrawables/ProgressType;)V", "currentGlobalAngle", "currentGlobalAngleOffset", "currentSweepAngle", "fBounds", "Landroid/graphics/RectF;", "getFBounds", "()Landroid/graphics/RectF;", "fBounds$delegate", "Lkotlin/Lazy;", "indeterminateAnimator", "Landroid/animation/AnimatorSet;", "modeAppearing", "", "paint", "Landroid/graphics/Paint;", "value", "progress", "getProgress", "()F", "setProgress", "(F)V", "getProgressType", "()Lcom/github/leandroborgesferreira/loadingbutton/animatedDrawables/ProgressType;", "setProgressType", "(Lcom/github/leandroborgesferreira/loadingbutton/animatedDrawables/ProgressType;)V", "shouldDraw", "angleValueAnimator", "Landroid/animation/ValueAnimator;", "timeInterpolator", "Landroid/animation/TimeInterpolator;", "dispose", "", "draw", "canvas", "Landroid/graphics/Canvas;", "getAngles", "Lkotlin/Pair;", "getOpacity", "isRunning", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setLoadingBarColor", "color", "start", "stop", "sweepValueAnimator", "toggleSweep", "loading-button-android_release"})
public final class CircularProgressAnimatedDrawable
extends Drawable
implements Animatable {
    @NotNull
    private final ProgressButton progressButton;
    private final float borderWidth;
    @NotNull
    private ProgressType progressType;
    @NotNull
    private final Lazy fBounds$delegate;
    @NotNull
    private final Paint paint;
    private float currentGlobalAngle;
    private float currentSweepAngle;
    private float currentGlobalAngleOffset;
    private boolean modeAppearing;
    private boolean shouldDraw;
    private float progress;
    @NotNull
    private final AnimatorSet indeterminateAnimator;

    /*
     * WARNING - void declaration
     */
    public CircularProgressAnimatedDrawable(@NotNull ProgressButton progressButton, float borderWidth, int arcColor, @NotNull ProgressType progressType) {
        void $this$indeterminateAnimator_u24lambda_u241;
        Paint $this$paint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)progressButton, (String)"progressButton");
        Intrinsics.checkNotNullParameter((Object)((Object)progressType), (String)"progressType");
        this.progressButton = progressButton;
        this.borderWidth = borderWidth;
        this.progressType = progressType;
        this.fBounds$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RectF>(this){
            final /* synthetic */ CircularProgressAnimatedDrawable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RectF invoke() {
                RectF rectF = new RectF();
                CircularProgressAnimatedDrawable circularProgressAnimatedDrawable = this.this$0;
                RectF $this$invoke_u24lambda_u240 = rectF;
                boolean bl = false;
                $this$invoke_u24lambda_u240.left = (float)circularProgressAnimatedDrawable.getBounds().left + CircularProgressAnimatedDrawable.access$getBorderWidth$p(circularProgressAnimatedDrawable) / 2.0f + 0.5f;
                $this$invoke_u24lambda_u240.right = (float)circularProgressAnimatedDrawable.getBounds().right - CircularProgressAnimatedDrawable.access$getBorderWidth$p(circularProgressAnimatedDrawable) / 2.0f - 0.5f;
                $this$invoke_u24lambda_u240.top = (float)circularProgressAnimatedDrawable.getBounds().top + CircularProgressAnimatedDrawable.access$getBorderWidth$p(circularProgressAnimatedDrawable) / 2.0f + 0.5f;
                $this$invoke_u24lambda_u240.bottom = (float)circularProgressAnimatedDrawable.getBounds().bottom - CircularProgressAnimatedDrawable.access$getBorderWidth$p(circularProgressAnimatedDrawable) / 2.0f - 0.5f;
                return rectF;
            }
        }));
        Paint paint2 = paint = new Paint();
        CircularProgressAnimatedDrawable circularProgressAnimatedDrawable = this;
        boolean bl = false;
        $this$paint_u24lambda_u240.setAntiAlias(true);
        $this$paint_u24lambda_u240.setStyle(Paint.Style.STROKE);
        $this$paint_u24lambda_u240.setStrokeWidth(this.borderWidth);
        $this$paint_u24lambda_u240.setColor(arcColor);
        circularProgressAnimatedDrawable.paint = paint;
        this.shouldDraw = true;
        $this$paint_u24lambda_u240 = paint = new AnimatorSet();
        circularProgressAnimatedDrawable = this;
        boolean bl2 = false;
        Animator[] animatorArray = new Animator[]{this.angleValueAnimator((TimeInterpolator)new LinearInterpolator()), this.sweepValueAnimator((TimeInterpolator)new AccelerateDecelerateInterpolator())};
        $this$indeterminateAnimator_u24lambda_u241.playTogether(animatorArray);
        circularProgressAnimatedDrawable.indeterminateAnimator = paint;
    }

    public /* synthetic */ CircularProgressAnimatedDrawable(ProgressButton progressButton, float f, int n, ProgressType progressType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            progressType = ProgressType.INDETERMINATE;
        }
        this(progressButton, f, n, progressType);
    }

    @NotNull
    public final ProgressType getProgressType() {
        return this.progressType;
    }

    public final void setProgressType(@NotNull ProgressType progressType) {
        Intrinsics.checkNotNullParameter((Object)((Object)progressType), (String)"<set-?>");
        this.progressType = progressType;
    }

    private final RectF getFBounds() {
        Lazy lazy = this.fBounds$delegate;
        return (RectF)lazy.getValue();
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        if (this.progressType == ProgressType.INDETERMINATE) {
            this.stop();
            this.progressType = ProgressType.DETERMINATE;
        }
        if (this.progress == value) {
            return;
        }
        this.progress = value > 100.0f ? 100.0f : (value < 0.0f ? 0.0f : value);
        this.progressButton.invalidate();
    }

    private final void toggleSweep() {
        boolean bl = this.modeAppearing = !this.modeAppearing;
        if (this.modeAppearing) {
            this.currentGlobalAngleOffset = (this.currentGlobalAngleOffset + 100.0f) % (float)360;
        }
    }

    private final ValueAnimator angleValueAnimator(TimeInterpolator timeInterpolator) {
        Object object = new float[]{0.0f, 360.0f};
        Object $this$angleValueAnimator_u24lambda_u243 = object = (Object)ValueAnimator.ofFloat((float[])object);
        boolean bl = false;
        $this$angleValueAnimator_u24lambda_u243.setInterpolator(timeInterpolator);
        $this$angleValueAnimator_u24lambda_u243.setDuration(2000L);
        $this$angleValueAnimator_u24lambda_u243.setRepeatCount(-1);
        $this$angleValueAnimator_u24lambda_u243.addUpdateListener(arg_0 -> CircularProgressAnimatedDrawable.angleValueAnimator$lambda$3$lambda$2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofFloat(0F, 360F).apply \u2026alue as Float }\n        }");
        return object;
    }

    private final ValueAnimator sweepValueAnimator(TimeInterpolator timeInterpolator) {
        Object object = new float[]{0.0f, 260.0f};
        Object $this$sweepValueAnimator_u24lambda_u245 = object = (Object)ValueAnimator.ofFloat((float[])object);
        boolean bl = false;
        $this$sweepValueAnimator_u24lambda_u245.setInterpolator(timeInterpolator);
        $this$sweepValueAnimator_u24lambda_u245.setDuration(700L);
        $this$sweepValueAnimator_u24lambda_u245.setRepeatCount(-1);
        $this$sweepValueAnimator_u24lambda_u245.addUpdateListener(arg_0 -> CircularProgressAnimatedDrawable.sweepValueAnimator$lambda$5$lambda$4(this, arg_0));
        $this$sweepValueAnimator_u24lambda_u245.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ CircularProgressAnimatedDrawable this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationRepeat(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                CircularProgressAnimatedDrawable.access$toggleSweep(this.this$0);
                CircularProgressAnimatedDrawable.access$setShouldDraw$p(this.this$0, false);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofFloat(0F, 360F - 2 * M\u2026\n            })\n        }");
        return object;
    }

    private final Pair<Float, Float> getAngles() {
        Pair pair;
        switch (WhenMappings.$EnumSwitchMapping$0[this.progressType.ordinal()]) {
            case 1: {
                pair = TuplesKt.to((Object)Float.valueOf(-90.0f), (Object)Float.valueOf(this.progress * 3.6f));
                break;
            }
            case 2: {
                if (this.modeAppearing) {
                    pair = TuplesKt.to((Object)Float.valueOf(this.currentGlobalAngle - this.currentGlobalAngleOffset), (Object)Float.valueOf(this.currentSweepAngle + 50.0f));
                    break;
                }
                pair = TuplesKt.to((Object)Float.valueOf(this.currentGlobalAngle - this.currentGlobalAngleOffset + this.currentSweepAngle), (Object)Float.valueOf(360.0f - this.currentSweepAngle - 50.0f));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    public final void setLoadingBarColor(int color) {
        this.paint.setColor(color);
    }

    public boolean isRunning() {
        return this.indeterminateAnimator.isRunning();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.indeterminateAnimator.start();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.indeterminateAnimator.end();
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Pair<Float, Float> pair = this.getAngles();
        float startAngle = ((Number)pair.component1()).floatValue();
        float sweepAngle = ((Number)pair.component2()).floatValue();
        canvas.drawArc(this.getFBounds(), startAngle, sweepAngle, false, this.paint);
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public int getOpacity() {
        return -2;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public final void dispose() {
        ExtensionsKt.disposeAnimator((Animator)this.indeterminateAnimator);
    }

    private static final void angleValueAnimator$lambda$3$lambda$2(CircularProgressAnimatedDrawable this$0, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Object object = animation.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        this$0.currentGlobalAngle = ((Float)object).floatValue();
    }

    private static final void sweepValueAnimator$lambda$5$lambda$4(CircularProgressAnimatedDrawable this$0, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Object object = animation.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        this$0.currentSweepAngle = ((Float)object).floatValue();
        if (this$0.currentSweepAngle < 5.0f) {
            this$0.shouldDraw = true;
        }
        if (this$0.shouldDraw) {
            this$0.progressButton.invalidate();
        }
    }

    public static final /* synthetic */ void access$toggleSweep(CircularProgressAnimatedDrawable $this) {
        $this.toggleSweep();
    }

    public static final /* synthetic */ void access$setShouldDraw$p(CircularProgressAnimatedDrawable $this, boolean bl) {
        $this.shouldDraw = bl;
    }

    public static final /* synthetic */ float access$getBorderWidth$p(CircularProgressAnimatedDrawable $this) {
        return $this.borderWidth;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgressType.values().length];
            try {
                nArray[ProgressType.DETERMINATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressType.INDETERMINATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

