/*
 * Decompiled with CFR 0.152.
 */
package com.github.lassana.circletimerwidget.widget;

import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import com.github.lassana.circletimerwidget.widget.CircleTimerView;
import com.github.lassana.circletimerwidget.widget.R;
import java.util.List;

class CircleTimerTouchHelper
extends ExploreByTouchHelper {
    private CircleTimerView mInstance;

    public CircleTimerTouchHelper(CircleTimerView forView) {
        super((View)forView);
        this.mInstance = forView;
    }

    protected int getVirtualViewAt(float x, float y) {
        return this.mInstance.calculateZoneIndex(x, y);
    }

    protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
        for (int i = 0; i < this.mInstance.getHitchCount(); ++i) {
            virtualViewIds.add(i);
        }
    }

    private String createTextForVirtualView(int virtualViewId) {
        return this.mInstance.getContext().getString(R.string.text_indicator_position, new Object[]{this.mInstance.getHitchNames() == null ? String.valueOf(virtualViewId) : this.mInstance.getHitchNames()[virtualViewId]});
    }

    protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
        String text = this.createTextForVirtualView(virtualViewId);
        event.setContentDescription((CharSequence)text);
        event.getText().add(text);
    }

    protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat node) {
        String text = this.createTextForVirtualView(virtualViewId);
        node.setContentDescription((CharSequence)text);
        node.setText((CharSequence)text);
        node.setBoundsInParent(new Rect(this.mInstance.getCanvasWidth() / 2 - this.mInstance.getRadius(), this.mInstance.getCanvasHeight() / 2 - this.mInstance.getRadius(), this.mInstance.getCanvasWidth() / 2 + this.mInstance.getRadius(), this.mInstance.getCanvasHeight() / 2 + this.mInstance.getRadius()));
        node.addAction(16);
    }

    protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
        if (action == 16) {
            this.invalidateVirtualView(virtualViewId);
            this.sendEventForVirtualView(virtualViewId, 1);
            return true;
        }
        return false;
    }
}

