/*
 * Decompiled with CFR 0.152.
 */
package com.sleepbot.datetimepicker.time;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Region;
import android.graphics.Typeface;
import android.util.Log;
import android.view.View;
import com.fourmob.datetimepicker.R;
import com.nineoldandroids.animation.Keyframe;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.PropertyValuesHolder;
import com.nineoldandroids.animation.ValueAnimator;

public class RadialTextsView
extends View {
    private static final String TAG = "RadialTextsView";
    private static final int DEGREES_IN_CIRCLE = 360;
    private static final int DEGREE_POSITION_TICK = 30;
    private final Paint mPaint = new Paint();
    private boolean mDrawValuesReady;
    private boolean mIsInitialized = false;
    private int mNumbersTextColor;
    private Typeface mTypefaceLight;
    private Typeface mTypefaceRegular;
    private String[] mTexts;
    private String[] mInnerTexts;
    private boolean mIs24HourMode;
    private boolean mHasInnerCircle;
    private float mCircleRadiusMultiplier;
    private float mAmPmCircleRadiusMultiplier;
    private float mNumbersRadiusMultiplier;
    private float mInnerNumbersRadiusMultiplier;
    private float mTextSizeMultiplier;
    private float mInnerTextSizeMultiplier;
    private int mXCenter;
    private int mYCenter;
    private float mCircleRadius;
    private boolean mTextGridValuesDirty;
    private float mTextSize;
    private float mInnerTextSize;
    private float[] mTextGridHeights;
    private float[] mTextGridWidths;
    private float[] mInnerTextGridHeights;
    private float[] mInnerTextGridWidths;
    private float mAnimationRadiusMultiplier;
    private float mTransitionMidRadiusMultiplier;
    private float mTransitionEndRadiusMultiplier;
    ObjectAnimator mDisappearAnimator;
    ObjectAnimator mReappearAnimator;
    private InvalidateUpdateListener mInvalidateUpdateListener;
    private float mSelectionRadiusMultiplier;
    private int mSelectionHourDegrees;
    private boolean mSelectionInnerCircle;
    private float mSelectionRadius;
    private Path mSelectorPath;

    public RadialTextsView(Context context) {
        super(context);
    }

    public void initialize(Resources res, String[] texts, String[] innerTexts, boolean is24HourMode, boolean disappearsOut, int selectionHourDegrees, boolean selectionInnerCircle) {
        if (this.mIsInitialized) {
            Log.e((String)TAG, (String)"This RadialTextsView may only be initialized once.");
            return;
        }
        this.mNumbersTextColor = res.getColor(R.color.numbers_text_color);
        String typefaceFamily = res.getString(R.string.radial_numbers_typeface);
        this.mTypefaceLight = Typeface.create((String)typefaceFamily, (int)0);
        String typefaceFamilyRegular = res.getString(R.string.sans_serif);
        this.mTypefaceRegular = Typeface.create((String)typefaceFamilyRegular, (int)0);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mTexts = texts;
        this.mInnerTexts = innerTexts;
        this.mIs24HourMode = is24HourMode;
        this.mHasInnerCircle = innerTexts != null;
        this.mSelectionRadiusMultiplier = Float.parseFloat(res.getString(R.string.selection_radius_multiplier));
        this.mSelectionHourDegrees = selectionHourDegrees;
        this.mSelectionInnerCircle = selectionInnerCircle;
        this.mSelectorPath = new Path();
        if (is24HourMode) {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.circle_radius_multiplier_24HourMode));
        } else {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.circle_radius_multiplier));
            this.mAmPmCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.ampm_circle_radius_multiplier));
        }
        this.mTextGridHeights = new float[7];
        this.mTextGridWidths = new float[7];
        if (this.mHasInnerCircle) {
            this.mNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.numbers_radius_multiplier_outer));
            this.mTextSizeMultiplier = Float.parseFloat(res.getString(R.string.text_size_multiplier_outer));
            this.mInnerNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.numbers_radius_multiplier_inner));
            this.mInnerTextSizeMultiplier = Float.parseFloat(res.getString(R.string.text_size_multiplier_inner));
            this.mInnerTextGridHeights = new float[7];
            this.mInnerTextGridWidths = new float[7];
        } else {
            this.mNumbersRadiusMultiplier = Float.parseFloat(res.getString(R.string.numbers_radius_multiplier_normal));
            this.mTextSizeMultiplier = Float.parseFloat(res.getString(R.string.text_size_multiplier_normal));
        }
        this.mAnimationRadiusMultiplier = 1.0f;
        this.mTransitionMidRadiusMultiplier = 1.0f + 0.05f * (float)(disappearsOut ? -1 : 1);
        this.mTransitionEndRadiusMultiplier = 1.0f + 0.3f * (float)(disappearsOut ? 1 : -1);
        this.mInvalidateUpdateListener = new InvalidateUpdateListener();
        this.mTextGridValuesDirty = true;
        this.mIsInitialized = true;
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    public void setAnimationRadiusMultiplier(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier = animationRadiusMultiplier;
        this.mTextGridValuesDirty = true;
    }

    public void onDraw(Canvas canvas) {
        int viewWidth = this.getWidth();
        if (viewWidth == 0 || !this.mIsInitialized) {
            return;
        }
        if (!this.mDrawValuesReady) {
            this.mXCenter = this.getWidth() / 2;
            this.mYCenter = this.getHeight() / 2;
            this.mCircleRadius = (float)Math.min(this.mXCenter, this.mYCenter) * this.mCircleRadiusMultiplier;
            if (!this.mIs24HourMode) {
                float amPmCircleRadius = this.mCircleRadius * this.mAmPmCircleRadiusMultiplier;
                this.mYCenter = (int)((float)this.mYCenter - amPmCircleRadius / 2.0f);
            }
            this.mTextSize = this.mCircleRadius * this.mTextSizeMultiplier;
            if (this.mHasInnerCircle) {
                this.mInnerTextSize = this.mCircleRadius * this.mInnerTextSizeMultiplier;
            }
            this.renderAnimations();
            this.mTextGridValuesDirty = true;
            this.mDrawValuesReady = true;
        }
        float numbersRadius = this.mCircleRadius * this.mNumbersRadiusMultiplier * this.mAnimationRadiusMultiplier;
        if (this.mTextGridValuesDirty) {
            this.calculateGridSizes(numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize, this.mTextGridHeights, this.mTextGridWidths);
            if (this.mHasInnerCircle) {
                float innerNumbersRadius = this.mCircleRadius * this.mInnerNumbersRadiusMultiplier * this.mAnimationRadiusMultiplier;
                this.calculateGridSizes(innerNumbersRadius, this.mXCenter, this.mYCenter, this.mInnerTextSize, this.mInnerTextGridHeights, this.mInnerTextGridWidths);
            }
            this.mSelectionRadius = (int)(this.mCircleRadius * this.mSelectionRadiusMultiplier);
            this.mTextGridValuesDirty = false;
        }
        this.mSelectorPath.reset();
        double selectionRadians = (double)this.mSelectionHourDegrees * Math.PI / 180.0;
        float selectorX = this.mXCenter + (int)((double)numbersRadius * Math.sin(selectionRadians));
        float selectorY = this.mYCenter - (int)((double)numbersRadius * Math.cos(selectionRadians));
        this.mSelectorPath.addCircle(selectorX, selectorY, this.mSelectionRadius, Path.Direction.CW);
        this.drawTexts(canvas, this.mTextSize, this.mTypefaceLight, this.mTexts, this.mTextGridWidths, this.mTextGridHeights, !this.mSelectionInnerCircle);
        if (this.mHasInnerCircle) {
            this.drawTexts(canvas, this.mInnerTextSize, this.mTypefaceRegular, this.mInnerTexts, this.mInnerTextGridWidths, this.mInnerTextGridHeights, this.mSelectionInnerCircle);
        }
    }

    private void calculateGridSizes(float numbersRadius, float xCenter, float yCenter, float textSize, float[] textGridHeights, float[] textGridWidths) {
        float offset1 = numbersRadius;
        float offset2 = numbersRadius * (float)Math.sqrt(3.0) / 2.0f;
        float offset3 = numbersRadius / 2.0f;
        this.mPaint.setTextSize(textSize);
        textGridHeights[0] = (yCenter -= (this.mPaint.descent() + this.mPaint.ascent()) / 2.0f) - offset1;
        textGridWidths[0] = xCenter - offset1;
        textGridHeights[1] = yCenter - offset2;
        textGridWidths[1] = xCenter - offset2;
        textGridHeights[2] = yCenter - offset3;
        textGridWidths[2] = xCenter - offset3;
        textGridHeights[3] = yCenter;
        textGridWidths[3] = xCenter;
        textGridHeights[4] = yCenter + offset3;
        textGridWidths[4] = xCenter + offset3;
        textGridHeights[5] = yCenter + offset2;
        textGridWidths[5] = xCenter + offset2;
        textGridHeights[6] = yCenter + offset1;
        textGridWidths[6] = xCenter + offset1;
    }

    private void drawTexts(Canvas canvas, float textSize, Typeface typeface, String[] texts, float[] textGridWidths, float[] textGridHeights, boolean useSelectionTextEffect) {
        this.mPaint.setTextSize(textSize);
        this.mPaint.setTypeface(typeface);
        this.drawText(canvas, texts, 0, textGridWidths[3], textGridHeights[0], useSelectionTextEffect);
        this.drawText(canvas, texts, 1, textGridWidths[4], textGridHeights[1], useSelectionTextEffect);
        this.drawText(canvas, texts, 2, textGridWidths[5], textGridHeights[2], useSelectionTextEffect);
        this.drawText(canvas, texts, 3, textGridWidths[6], textGridHeights[3], useSelectionTextEffect);
        this.drawText(canvas, texts, 4, textGridWidths[5], textGridHeights[4], useSelectionTextEffect);
        this.drawText(canvas, texts, 5, textGridWidths[4], textGridHeights[5], useSelectionTextEffect);
        this.drawText(canvas, texts, 6, textGridWidths[3], textGridHeights[6], useSelectionTextEffect);
        this.drawText(canvas, texts, 7, textGridWidths[2], textGridHeights[5], useSelectionTextEffect);
        this.drawText(canvas, texts, 8, textGridWidths[1], textGridHeights[4], useSelectionTextEffect);
        this.drawText(canvas, texts, 9, textGridWidths[0], textGridHeights[3], useSelectionTextEffect);
        this.drawText(canvas, texts, 10, textGridWidths[1], textGridHeights[2], useSelectionTextEffect);
        this.drawText(canvas, texts, 11, textGridWidths[2], textGridHeights[1], useSelectionTextEffect);
    }

    private void drawText(Canvas canvas, String[] texts, int position, float x, float y, boolean useSelectionTextEffect) {
        int positionDegrees;
        boolean useSelectionTextColor = false;
        if (useSelectionTextEffect && (positionDegrees = position * 30) < this.mSelectionHourDegrees + 30) {
            if (positionDegrees > this.mSelectionHourDegrees - 30) {
                useSelectionTextColor = true;
            } else if (positionDegrees == 0 && this.mSelectionHourDegrees > 330) {
                useSelectionTextColor = true;
            }
        }
        String text = texts[position];
        if (!useSelectionTextColor) {
            this.mPaint.setColor(this.mNumbersTextColor);
            canvas.drawText(text, x, y, this.mPaint);
            return;
        }
        canvas.save(2);
        canvas.clipPath(this.mSelectorPath, Region.Op.DIFFERENCE);
        this.mPaint.setColor(this.mNumbersTextColor);
        canvas.drawText(text, x, y, this.mPaint);
        canvas.restore();
        canvas.save(2);
        canvas.clipPath(this.mSelectorPath);
        this.mPaint.setColor(-1);
        canvas.drawText(text, x, y, this.mPaint);
        canvas.restore();
    }

    private void renderAnimations() {
        float midwayPoint = 0.2f;
        int duration = 500;
        Keyframe kf0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe kf1 = Keyframe.ofFloat((float)midwayPoint, (float)this.mTransitionMidRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat((float)1.0f, (float)this.mTransitionEndRadiusMultiplier);
        PropertyValuesHolder radiusDisappear = PropertyValuesHolder.ofKeyframe((String)"animationRadiusMultiplier", (Keyframe[])new Keyframe[]{kf0, kf1, kf2});
        kf0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        kf1 = Keyframe.ofFloat((float)1.0f, (float)0.0f);
        PropertyValuesHolder fadeOut = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])new Keyframe[]{kf0, kf1});
        this.mDisappearAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{radiusDisappear, fadeOut}).setDuration((long)duration);
        this.mDisappearAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mInvalidateUpdateListener);
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        midwayPoint = 1.0f - midwayPoint * (1.0f - delayPoint);
        kf0 = Keyframe.ofFloat((float)0.0f, (float)this.mTransitionEndRadiusMultiplier);
        kf1 = Keyframe.ofFloat((float)delayPoint, (float)this.mTransitionEndRadiusMultiplier);
        kf2 = Keyframe.ofFloat((float)midwayPoint, (float)this.mTransitionMidRadiusMultiplier);
        Keyframe kf3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder radiusReappear = PropertyValuesHolder.ofKeyframe((String)"animationRadiusMultiplier", (Keyframe[])new Keyframe[]{kf0, kf1, kf2, kf3});
        kf0 = Keyframe.ofFloat((float)0.0f, (float)0.0f);
        kf1 = Keyframe.ofFloat((float)delayPoint, (float)0.0f);
        kf2 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder fadeIn = PropertyValuesHolder.ofKeyframe((String)"alpha", (Keyframe[])new Keyframe[]{kf0, kf1, kf2});
        this.mReappearAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{radiusReappear, fadeIn}).setDuration((long)totalDuration);
        this.mReappearAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mInvalidateUpdateListener);
    }

    public ObjectAnimator getDisappearAnimator() {
        if (!this.mIsInitialized || !this.mDrawValuesReady || this.mDisappearAnimator == null) {
            Log.e((String)TAG, (String)"RadialTextView was not ready for animation.");
            return null;
        }
        return this.mDisappearAnimator;
    }

    public ObjectAnimator getReappearAnimator() {
        if (!this.mIsInitialized || !this.mDrawValuesReady || this.mReappearAnimator == null) {
            Log.e((String)TAG, (String)"RadialTextView was not ready for animation.");
            return null;
        }
        return this.mReappearAnimator;
    }

    public void setSelection(int hourDegrees, boolean hourInnerCircle) {
        this.mSelectionHourDegrees = hourDegrees;
        this.mSelectionInnerCircle = hourInnerCircle;
    }

    private class InvalidateUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private InvalidateUpdateListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            RadialTextsView.this.invalidate();
        }
    }
}

