/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker.date;

import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.fourmob.datetimepicker.R;
import java.util.ArrayList;
import java.util.List;

public class YearPickerView
extends LinearLayout
implements AdapterView.OnItemClickListener,
AbsListView.OnScrollListener {
    private ListView mListView;
    private YearAdapter mAdapter;
    ArrayList<Integer> yearRange = new ArrayList();
    private int mSelectedYear = -1;
    private YearPickerListener mListener;
    private View mMoreContentIndicator;
    private boolean mUseContentIndicator;
    private int mViewSize;

    public YearPickerView(Context context) {
        super(context);
        this.setOrientation(1);
        Resources resources = context.getResources();
        this.mViewSize = resources.getDimensionPixelOffset(R.dimen.date_picker_view_animator_height);
        this.mListView = new ListView(context);
        this.mListView.setSelector(17170445);
        this.mListView.setCacheColorHint(0);
        LinearLayout.LayoutParams listLayoutParams = new LinearLayout.LayoutParams(-1, 0);
        listLayoutParams.weight = 1.0f;
        this.addView((View)this.mListView, (ViewGroup.LayoutParams)listLayoutParams);
        this.mUseContentIndicator = true;
        this.mMoreContentIndicator = LayoutInflater.from((Context)context).inflate(R.layout.year_picker_footer, (ViewGroup)this, false);
        this.addView(this.mMoreContentIndicator);
        this.mAdapter = new YearAdapter(this.yearRange);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mListView.setDividerHeight(0);
    }

    private static int getYearFromTextView(TextView view) {
        return Integer.valueOf(view.getText().toString());
    }

    private boolean isAtBottom() {
        int count = this.mListView.getAdapter().getCount();
        if (count == 0) {
            return true;
        }
        if (this.mListView.getLastVisiblePosition() == count - 1) {
            return this.mListView.getChildAt(count - 1).getBottom() <= this.mListView.getHeight();
        }
        return false;
    }

    public int getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    public void updateContent(int selectedYear, int minYear, int maxYear) {
        this.mSelectedYear = selectedYear;
        if (this.yearRange.size() > 0 && (this.yearRange.get(0) != minYear || this.yearRange.get(this.yearRange.size() - 1) != maxYear)) {
            this.yearRange.clear();
        }
        if (this.yearRange.size() == 0) {
            for (int year = minYear; year <= maxYear; ++year) {
                this.yearRange.add(year);
            }
        }
        this.mAdapter.notifyDataSetChanged();
        if (this.isAtBottom()) {
            this.mUseContentIndicator = false;
            this.mMoreContentIndicator.setVisibility(8);
        }
        this.postSetSelectionFromTop(selectedYear - minYear, this.mViewSize / 3);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        TextView clickedView = (TextView)view;
        if (clickedView != null) {
            this.mAdapter.notifyDataSetChanged();
            if (this.mListener != null) {
                this.mListener.onYearSelected(YearPickerView.getYearFromTextView(clickedView));
            }
        }
    }

    public void postSetSelectionFromTop(final int position, final int y) {
        this.post(new Runnable(){

            @Override
            public void run() {
                YearPickerView.this.mListView.setSelectionFromTop(position, y);
                YearPickerView.this.requestLayout();
            }
        });
    }

    public int getFirstVisiblePosition() {
        if (this.mListView == null) {
            return 0;
        }
        return this.mListView.getFirstVisiblePosition();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (!this.mUseContentIndicator) {
            return;
        }
        int lastItem = firstVisibleItem + visibleItemCount;
        if (lastItem == totalItemCount && this.isAtBottom()) {
            this.mMoreContentIndicator.setVisibility(8);
        } else {
            this.mMoreContentIndicator.setVisibility(0);
        }
    }

    public void setListener(YearPickerListener listener) {
        this.mListener = listener;
    }

    private class YearAdapter
    extends BaseAdapter {
        private static final int DEFAULT_ITEM_TYPE = 0;
        private static final int SELECTED_ITEM_TYPE = 1;
        private List<Integer> years;

        public YearAdapter(List<Integer> years) {
            this.years = years;
        }

        public int getCount() {
            return this.years.size();
        }

        public Integer getItem(int position) {
            return this.years.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public int getItemViewType(int position) {
            if (this.getItem(position) == YearPickerView.this.mSelectedYear) {
                return 1;
            }
            return 0;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                int layoutId = this.getItemViewType(position) == 1 ? R.layout.year_label_text_view_selected : R.layout.year_label_text_view;
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(layoutId, parent, false);
            }
            Integer year = this.getItem(position);
            TextView yearLabel = (TextView)convertView;
            yearLabel.setText((CharSequence)String.format("%d", year));
            return convertView;
        }
    }

    public static interface YearPickerListener {
        public void onYearSelected(int var1);
    }
}

