/*
 * Decompiled with CFR 0.152.
 */
package com.fourmob.datetimepicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.fourmob.datetimepicker.R;
import com.nineoldandroids.animation.Keyframe;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.PropertyValuesHolder;

public class Utils {
    public static final int PULSE_ANIMATOR_DURATION = 544;
    public static final int MONTHS_IN_YEAR = 12;

    public static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    public static int getMonthsBetweenDates(int startMonth, int startYear, int endMonth, int endYear) {
        return (endYear - startYear) * 12 + endMonth - startMonth + 1;
    }

    public static ObjectAnimator getPulseAnimator(View labelToAnimate, float decreaseRatio, float increaseRatio) {
        Keyframe k0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe k1 = Keyframe.ofFloat((float)0.275f, (float)decreaseRatio);
        Keyframe k2 = Keyframe.ofFloat((float)0.69f, (float)increaseRatio);
        Keyframe k3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        ObjectAnimator pulseAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)labelToAnimate, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
        pulseAnimator.setDuration(544L);
        return pulseAnimator;
    }

    public static boolean isJellybeanOrLater() {
        return Build.VERSION.SDK_INT >= 16;
    }

    @SuppressLint(value={"NewApi"})
    public static void tryAccessibilityAnnounce(View view, CharSequence text) {
        if (Utils.isJellybeanOrLater() && view != null && text != null) {
            view.announceForAccessibility(text);
        }
    }

    public static boolean isTouchExplorationEnabled(AccessibilityManager accessibilityManager) {
        if (Build.VERSION.SDK_INT >= 14) {
            return accessibilityManager.isTouchExplorationEnabled();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getColorAttribute(Context context, int attribute) {
        TypedValue typedValue = new TypedValue();
        TypedArray a = null;
        try {
            a = context.obtainStyledAttributes(typedValue.data, new int[]{attribute});
            int n = a.getColor(0, -16777216);
            return n;
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public static int getPrimaryColor(Context context) {
        return Utils.getColorAttribute(context, R.attr.colorPrimary);
    }

    public static int getPrimaryDarkColor(Context context) {
        return Utils.getColorAttribute(context, R.attr.colorPrimaryDark);
    }

    public static ColorStateList createThemedTextColorStateList(Context context) {
        int[][] states = new int[][]{{16842910}, {-16842910}};
        int[] colors = new int[]{Utils.getPrimaryColor(context), context.getResources().getColor(R.color.done_text_color_disabled)};
        return new ColorStateList((int[][])states, colors);
    }
}

