package in.kyle.api.generate.helper;

import javassist.ClassPool;
import javassist.CtClass;

import in.kyle.api.utils.Try;

public final class Assist {
    
    public static final ClassPool POOL = ClassPool.getDefault();
    
    private Assist() {
    }
    
    public static CtClass getClass(Class<?> clazz) {
        return Try.to(() -> POOL.get(clazz.getName()));
    }
    
    public static CtClass[] getClasses(Class<?>... classes) {
        CtClass[] arr = new CtClass[classes.length];
        for (int i = 0; i < classes.length; i++) {
            arr[i] = getClass(classes[i]);
        }
        return arr;
    }
}