/*
 * Decompiled with CFR 0.152.
 */
package com.github.kxfeng.securepreferences;

import android.os.Build;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

class CryptoUtil {
    private static SecureRandom sSecureRandom = new SecureRandom();

    CryptoUtil() {
    }

    static byte[] randomBytes(int byteLength) {
        byte[] bytes = new byte[byteLength];
        sSecureRandom.nextBytes(bytes);
        return bytes;
    }

    static AlgorithmParameterSpec getGcmParameterSpec(byte[] iv, int tagLen) {
        if (Build.VERSION.SDK_INT < 21) {
            if (tagLen != 128) {
                throw new IllegalArgumentException("Android 4.4 only support 128 bits tag length");
            }
            return new IvParameterSpec(iv);
        }
        return new GCMParameterSpec(tagLen, iv);
    }
}

