/*
 * Decompiled with CFR 0.152.
 */
package com.github.kxfeng.securepreferences;

import android.support.annotation.NonNull;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;

class CiphertextIv {
    private static final String DELIMITER = ":";
    private static final int BASE64_FLAGS = 2;
    final byte[] ciphertext;
    final byte[] iv;

    CiphertextIv(byte[] ciphertext, byte[] iv) {
        this.ciphertext = new byte[ciphertext.length];
        System.arraycopy(ciphertext, 0, this.ciphertext, 0, ciphertext.length);
        this.iv = new byte[iv.length];
        System.arraycopy(iv, 0, this.iv, 0, iv.length);
    }

    CiphertextIv(@NonNull String encodedText) throws IllegalCiphertextIvException {
        String[] parts = encodedText.split(DELIMITER);
        if (parts.length != 2) {
            throw new IllegalCiphertextIvException("CiphertextIv not this format: cipher:iv");
        }
        try {
            this.ciphertext = Base64.decode((byte[])parts[0].getBytes("UTF-8"), (int)2);
            this.iv = Base64.decode((byte[])parts[1].getBytes("UTF-8"), (int)2);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalCiphertextIvException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return Base64.encodeToString((byte[])this.ciphertext, (int)2) + DELIMITER + Base64.encodeToString((byte[])this.iv, (int)2);
    }

    private static class IllegalCiphertextIvException
    extends GeneralSecurityException {
        IllegalCiphertextIvException(String msg) {
            super(msg);
        }

        IllegalCiphertextIvException(Throwable cause) {
            super(cause);
        }
    }
}

