/*
 * Decompiled with CFR 0.152.
 */
package com.github.kvnxiao.jsonequals;

import com.github.kvnxiao.jsonequals.JsonCompareResult;
import com.github.kvnxiao.jsonequals.JsonEquals;
import java.util.Map;
import java.util.Set;
import me.doubledutch.lazyjson.LazyArray;
import me.doubledutch.lazyjson.LazyElement;
import me.doubledutch.lazyjson.LazyObject;
import me.doubledutch.lazyjson.LazyType;

public class JsonRoot {
    private final LazyElement root;
    private final LazyType rootType;

    private JsonRoot(LazyElement root) {
        this.root = root;
        this.rootType = root.getType();
    }

    private JsonRoot(String raw) {
        if (raw.startsWith("{")) {
            this.rootType = LazyType.OBJECT;
            this.root = new LazyObject(raw);
        } else if (raw.startsWith("[")) {
            this.rootType = LazyType.ARRAY;
            this.root = new LazyArray(raw);
        } else {
            this.rootType = LazyType.NULL;
            this.root = null;
        }
    }

    public static JsonRoot from(LazyElement root) {
        return new JsonRoot(root);
    }

    public static JsonRoot from(String raw) {
        return new JsonRoot(raw);
    }

    public JsonCompareResult compareTo(JsonRoot other, Set<String> ignoreFields, Map<String, String> pruneFields) {
        if (other != null) {
            if (this.isRootObject() && other.isRootObject()) {
                return JsonEquals.ofType(LazyType.OBJECT).withSource(this.getRoot()).withComparate(other.getRoot()).withIgnoreFields(ignoreFields).withPruneFields(pruneFields).compare();
            }
            if (this.isRootArray() && other.isRootArray()) {
                return JsonEquals.ofType(LazyType.ARRAY).withSource(this.getRoot()).withComparate(other.getRoot()).withIgnoreFields(ignoreFields).withPruneFields(pruneFields).compare();
            }
        }
        return null;
    }

    public JsonCompareResult compareTo(JsonRoot other) {
        return this.compareTo(other, null, null);
    }

    public JsonCompareResult compareToWithIgnore(JsonRoot other, Set<String> ignoreFields) {
        return this.compareTo(other, ignoreFields, null);
    }

    public JsonCompareResult compareToWithPrune(JsonRoot other, Map<String, String> pruneFields) {
        return this.compareTo(other, null, pruneFields);
    }

    public LazyElement getRoot() {
        return this.root;
    }

    public boolean isRootObject() {
        return this.rootType == LazyType.OBJECT;
    }

    public boolean isRootArray() {
        return this.rootType == LazyType.ARRAY;
    }

    public String toString() {
        return this.root.toString();
    }
}

