/*
 * Decompiled with CFR 0.152.
 */
package com.natasa.progressviews;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.natasa.progressviews.ProgressView;
import com.natasa.progressviews.utils.ProgressStartPoint;
import com.natasa.progressviews.utils.ShapeType;

public class CircleSegmentBar
extends ProgressView {
    public static final int rad_360 = 360;
    private float SEGMENT_WIDTH = 3.0f;
    private int PADDING = 10;
    private Path progressPath;
    private Path backgroundPath;
    final RectF oval = new RectF();
    private float radius;
    private float angle;
    private int angleStartPoint = ProgressStartPoint.DEFAULT.getValue();
    private float left;
    private float top;
    private float right;
    private float bottom;
    private boolean isGradientColor;

    public CircleSegmentBar(Context context) {
        super(context);
    }

    public CircleSegmentBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    void init() {
        this.initBackgroundColor();
        this.initForegroundColor();
        this.progressPath = new Path();
        this.backgroundPath = new Path();
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        this.radius = width > height ? (float)(height / 3) : (float)(width / 3);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.left = 0.0f + this.strokeWidth / 2.0f;
        this.top = 0.0f + this.strokeWidth / 2.0f;
        this.right = (float)this.min - this.strokeWidth / 2.0f;
        this.bottom = (float)this.min - this.strokeWidth / 2.0f;
        this.oval.set(this.left + (float)this.PADDING, this.top + (float)this.PADDING, this.right - (float)this.PADDING, this.bottom - (float)this.PADDING);
    }

    public void onDraw(Canvas canvas) {
        this.drawGradientColor();
        this.drawCircle(canvas);
    }

    private void drawCircle(Canvas canvas) {
        int i;
        this.backgroundPath.reset();
        for (i = 0; i < 360; i += 5) {
            this.backgroundPath.addArc(this.oval, (float)i, this.SEGMENT_WIDTH);
        }
        canvas.drawPath(this.backgroundPath, this.backgroundPaint);
        this.progressPath.reset();
        this.angle = (float)(360 * (int)this.progress) / this.maximum_progress + (float)this.angleStartPoint;
        i = this.angleStartPoint;
        while ((float)i < this.angle) {
            this.progressPath.addArc(this.oval, (float)i, this.SEGMENT_WIDTH);
            i += 5;
        }
        canvas.drawPath(this.progressPath, this.foregroundPaint);
        this.drawText(canvas);
    }

    public void setCircleViewPadding(int padding) {
        this.PADDING = padding;
        this.invalidate();
    }

    public float getSegmentWidth() {
        return this.SEGMENT_WIDTH;
    }

    public void setSegmentWidth(float segment_width) {
        this.SEGMENT_WIDTH = segment_width;
    }

    public int getPadding() {
        return this.PADDING;
    }

    public int getProgressStartPosition() {
        return this.startPosInDegrees;
    }

    public void setStartPositionInDegrees(int degrees) {
        this.startPosInDegrees = degrees;
    }

    public void setStartPositionInDegrees(ProgressStartPoint position) {
        this.startPosInDegrees = position.getValue();
    }

    private void drawGradientColor() {
        if (this.isGradientColor) {
            this.setLinearGradientProgress(this.gradColors);
        }
    }

    public void setLinearGradientProgress(boolean isGradientColor) {
        this.isGradientColor = isGradientColor;
    }

    public void setLinearGradientProgress(boolean isGradientColor, int[] colors) {
        this.isGradientColor = isGradientColor;
        this.gradColors = colors;
    }

    private void setLinearGradientProgress(int[] gradColors) {
        if (gradColors != null) {
            this.colorHelper.setGradientPaint(this.foregroundPaint, this.left, this.top, this.right, this.bottom, gradColors);
        } else {
            this.colorHelper.setGradientPaint(this.foregroundPaint, this.left, this.top, this.right, this.bottom);
        }
    }

    @Override
    public ShapeType setType(ShapeType type) {
        return ShapeType.SEGMENT_CIRCLE;
    }
}

