/*
 * Decompiled with CFR 0.152.
 */
package com.natasa.progressviews;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.natasa.progressviews.ProgressView;
import com.natasa.progressviews.utils.ShapeType;

public class ArcProgressBar
extends ProgressView {
    private static final int START_ANGLE = 180;
    private int PADDING = 0;
    private float left;
    private float right;
    private RectF oval;
    private float top;
    private float bottom;
    private boolean isGradientColor;

    public ArcProgressBar(Context context) {
        super(context);
    }

    public ArcProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ArcProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    void init() {
        this.oval = new RectF();
        this.initForegroundColor();
        this.initBackgroundColor();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.oval, 180.0f, 180.0f, false, this.backgroundPaint);
        this.setLinearGradientPaint();
        float angle = 180.0f * this.progress / this.maximum_progress;
        canvas.drawArc(this.oval, 180.0f, angle, false, this.foregroundPaint);
    }

    private void setLinearGradientPaint() {
        if (this.isGradientColor) {
            this.setLinearGradientProgress(this.gradColors);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.left = 0.0f + this.strokeWidth / 2.0f;
        this.top = 0.0f + this.strokeWidth / 2.0f;
        this.right = (float)this.min - this.strokeWidth / 2.0f;
        this.bottom = (float)this.min - this.strokeWidth / 2.0f;
        this.oval.set(this.left + (float)this.PADDING, this.top + (float)this.PADDING, this.right - (float)this.PADDING, this.bottom - (float)this.PADDING);
    }

    public void setArcViewPadding(int padding) {
        this.PADDING = padding;
        this.invalidate();
    }

    public void setLinearGradientProgress(boolean isGradientColor, int[] colors) {
        this.isGradientColor = isGradientColor;
        this.gradColors = colors;
    }

    private void setLinearGradientProgress(int[] gradColors) {
        if (gradColors != null) {
            this.colorHelper.setGradientPaint(this.foregroundPaint, this.left, this.top, this.right, this.top, gradColors);
        } else {
            this.colorHelper.setGradientPaint(this.foregroundPaint, this.left, this.top, this.right, this.top);
        }
    }

    public int getPadding() {
        return this.PADDING;
    }

    @Override
    public ShapeType setType(ShapeType type) {
        return ShapeType.ARC;
    }
}

