/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.baseokhttp.util;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public abstract class RequestBodyImpl
extends RequestBody {
    private final RequestBody requestBody;
    private BufferedSink bufferedSink;

    public RequestBodyImpl(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.bufferedSink == null) {
            this.bufferedSink = Okio.buffer((Sink)this.sink((Sink)sink));
        }
        this.requestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }

    private Sink sink(Sink sink) {
        return new ForwardingSink(sink){
            private long current;
            private long total;
            private long last;
            {
                this.last = 0L;
            }

            public void write(Buffer source, long byteCount) throws IOException {
                super.write(source, byteCount);
                if (this.total == 0L) {
                    this.total = RequestBodyImpl.this.contentLength();
                }
                this.current += byteCount;
                long now = this.current;
                if (this.last < now) {
                    RequestBodyImpl.this.loading(now, this.total, this.total == this.current);
                    this.last = now;
                }
            }
        };
    }

    public abstract void loading(long var1, long var3, boolean var5);
}

