/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.baseokhttp.util;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class LockLog {
    private static List<LogBody> logS;
    private static Thread logThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logI(String tag, String s) {
        Class<LockLog> clazz = LockLog.class;
        synchronized (LockLog.class) {
            if (logS == null) {
                logS = new ArrayList<LogBody>();
            }
            logS.add(new LogBody(LogBody.LEVEL.INFO, tag, s));
            LockLog.logPrint();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logE(String tag, String s) {
        Class<LockLog> clazz = LockLog.class;
        synchronized (LockLog.class) {
            if (logS == null) {
                logS = new ArrayList<LogBody>();
            }
            logS.add(new LogBody(LogBody.LEVEL.ERROR, tag, s));
            LockLog.logPrint();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(List<LogBody> s) {
        Class<LockLog> clazz = LockLog.class;
        synchronized (LockLog.class) {
            if (logS == null) {
                logS = new ArrayList<LogBody>();
            }
            logS.addAll(s);
            LockLog.logPrint();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void logPrint() {
        if (logThread == null) {
            logThread = new Thread(){

                @Override
                public void run() {
                    if (logS != null) {
                        while (!logS.isEmpty()) {
                            LogBody log = (LogBody)logS.get(0);
                            if (log == null) continue;
                            switch (log.getLevel()) {
                                case INFO: {
                                    Log.i((String)log.getTag(), (String)log.getLog());
                                    break;
                                }
                                case ERROR: {
                                    Log.e((String)log.getTag(), (String)log.getLog());
                                }
                            }
                            logS.remove(log);
                        }
                        logThread = null;
                    }
                }
            };
            logThread.start();
        }
    }

    public static String getExceptionInfo(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static class Builder {
        private List<LogBody> list = new ArrayList<LogBody>();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder i(String tag, String s) {
            this.list.add(new LogBody(tag, s));
            return this;
        }

        public Builder e(String tag, String s) {
            this.list.add(new LogBody(LogBody.LEVEL.ERROR, tag, s));
            return this;
        }

        public Builder add(List<LogBody> l) {
            this.list.addAll(l);
            return this;
        }

        public void build() {
            LockLog.log(this.list);
        }
    }

    public static class LogBody {
        String tag;
        String log;
        LEVEL level;

        public LogBody(LEVEL level, String tag, String log) {
            this.tag = tag;
            this.log = log;
            this.level = level;
        }

        public LogBody(String tag, String log) {
            this.tag = tag;
            this.log = log;
            this.level = LEVEL.INFO;
        }

        public String getTag() {
            return this.tag == null ? ">>>" : this.tag;
        }

        public LogBody setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public LEVEL getLevel() {
            return this.level;
        }

        public String getLog() {
            return this.log == null ? "" : this.log;
        }

        public LogBody setLog(String log) {
            this.log = log;
            return this;
        }

        public static enum LEVEL {
            INFO,
            ERROR;

        }
    }
}

