/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.baseokhttp;

import android.app.Activity;
import android.content.Context;
import android.webkit.MimeTypeMap;
import com.kongzue.baseokhttp.exceptions.TimeOutException;
import com.kongzue.baseokhttp.listener.BaseResponseListener;
import com.kongzue.baseokhttp.listener.CustomOkHttpClient;
import com.kongzue.baseokhttp.listener.CustomOkHttpClientBuilder;
import com.kongzue.baseokhttp.listener.JsonResponseListener;
import com.kongzue.baseokhttp.listener.MultipartBuilderInterceptor;
import com.kongzue.baseokhttp.listener.OnDownloadListener;
import com.kongzue.baseokhttp.listener.ResponseListener;
import com.kongzue.baseokhttp.listener.UploadProgressListener;
import com.kongzue.baseokhttp.util.BaseOkHttp;
import com.kongzue.baseokhttp.util.JsonFormat;
import com.kongzue.baseokhttp.util.JsonList;
import com.kongzue.baseokhttp.util.JsonMap;
import com.kongzue.baseokhttp.util.LockLog;
import com.kongzue.baseokhttp.util.Parameter;
import com.kongzue.baseokhttp.util.RequestBodyImpl;
import com.kongzue.baseokhttp.util.RequestInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.Proxy;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class HttpRequest
extends BaseOkHttp {
    private OkHttpClient okHttpClient;
    private Call httpCall;
    private String customMimeType;
    private Parameter parameter;
    private Parameter headers;
    private WeakReference<Context> context;
    private HttpRequest httpRequest;
    private BaseResponseListener responseListener;
    private String requestUrl;
    private String jsonParameter;
    private String stringParameter;
    private int timeoutDuration = TIME_OUT_DURATION;
    private Proxy proxy;
    private UploadProgressListener uploadProgressListener;
    private CustomOkHttpClient customOkHttpClient;
    private CustomOkHttpClientBuilder customOkHttpClientBuilder;
    private String cookieStr;
    private int requestType;
    private boolean isSending;
    private boolean isFileRequest = false;
    private boolean isJsonRequest = false;
    private boolean isStringRequest = false;
    private boolean skipSSLCheck = false;
    private String url;
    private RequestInfo requestInfo;
    private int oldDownloadProgress = -1;
    private Timer timer;
    private static int reserveUrlIndex;
    private File downloadFile;
    private OnDownloadListener onDownloadListener;
    private MultipartBuilderInterceptor multipartBuilderInterceptor;

    public static void POST(Context context, String url, Parameter parameter, BaseResponseListener listener) {
        HttpRequest.POST(context, url, null, parameter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void POST(Context context, String url, Parameter headers, Parameter parameter, BaseResponseListener listener) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.headers = headers;
            httpRequest.responseListener = listener;
            httpRequest.parameter = parameter;
            httpRequest.requestUrl = url;
            httpRequest.requestType = 0;
            httpRequest.httpRequest = httpRequest;
            httpRequest.send();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void JSONPOST(Context context, String url, String jsonParameter, BaseResponseListener listener) {
        HttpRequest.JSONPOST(context, url, null, jsonParameter, listener);
    }

    public static void JSONPOST(Context context, String url, JsonMap jsonMap, BaseResponseListener listener) {
        HttpRequest.JSONPOST(context, url, null, jsonMap.toString(), listener);
    }

    public static void JSONPOST(Context context, String url, JSONObject jsonObject, BaseResponseListener listener) {
        HttpRequest.JSONPOST(context, url, null, jsonObject.toString(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void JSONPOST(Context context, String url, Parameter headers, String jsonParameter, BaseResponseListener listener) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.headers = headers;
            httpRequest.responseListener = listener;
            httpRequest.jsonParameter = jsonParameter;
            httpRequest.requestUrl = url;
            httpRequest.requestType = 0;
            httpRequest.httpRequest = httpRequest;
            httpRequest.send();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void JSONPOST(Context context, String url, Parameter headers, JsonMap jsonMap, BaseResponseListener listener) {
        HttpRequest.JSONPOST(context, url, headers, jsonMap.toString(), listener);
    }

    public static void JSONPOST(Context context, String url, Parameter headers, JSONObject jsonObject, BaseResponseListener listener) {
        HttpRequest.JSONPOST(context, url, headers, jsonObject.toString(), listener);
    }

    public static void StringPOST(Context context, String url, String stringParameter, BaseResponseListener listener) {
        HttpRequest.StringPOST(context, url, null, stringParameter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StringPOST(Context context, String url, Parameter headers, String stringParameter, BaseResponseListener listener) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.headers = headers;
            httpRequest.responseListener = listener;
            httpRequest.stringParameter = stringParameter;
            httpRequest.requestUrl = url;
            httpRequest.requestType = 0;
            httpRequest.httpRequest = httpRequest;
            httpRequest.send();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void GET(Context context, String url, Parameter parameter, BaseResponseListener listener) {
        HttpRequest.GET(context, url, null, parameter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GET(Context context, String url, Parameter headers, Parameter parameter, BaseResponseListener listener) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.headers = headers;
            httpRequest.responseListener = listener;
            httpRequest.parameter = parameter;
            httpRequest.requestUrl = url;
            httpRequest.requestType = 1;
            httpRequest.httpRequest = httpRequest;
            httpRequest.send();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void PUT(Context context, String url, Parameter parameter, BaseResponseListener listener) {
        HttpRequest.PUT(context, url, null, parameter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PUT(Context context, String url, Parameter headers, Parameter parameter, BaseResponseListener listener) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.headers = headers;
            httpRequest.responseListener = listener;
            httpRequest.parameter = parameter;
            httpRequest.requestUrl = url;
            httpRequest.requestType = 2;
            httpRequest.httpRequest = httpRequest;
            httpRequest.send();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void DELETE(Context context, String url, Parameter parameter, BaseResponseListener listener) {
        HttpRequest.DELETE(context, url, null, parameter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DELETE(Context context, String url, Parameter headers, Parameter parameter, BaseResponseListener listener) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.headers = headers;
            httpRequest.responseListener = listener;
            httpRequest.parameter = parameter;
            httpRequest.requestUrl = url;
            httpRequest.requestType = 3;
            httpRequest.httpRequest = httpRequest;
            httpRequest.send();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void PATCH(Context context, String url, Parameter parameter, BaseResponseListener listener) {
        HttpRequest.PATCH(context, url, null, parameter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PATCH(Context context, String url, Parameter headers, Parameter parameter, BaseResponseListener listener) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.headers = headers;
            httpRequest.responseListener = listener;
            httpRequest.parameter = parameter;
            httpRequest.requestUrl = url;
            httpRequest.requestType = 5;
            httpRequest.httpRequest = httpRequest;
            httpRequest.send();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DOWNLOAD(Context context, String url, File downloadFile, OnDownloadListener onDownloadListener) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.requestUrl = url;
            httpRequest.doDownload(downloadFile, onDownloadListener);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void send() {
        block29: {
            List<LockLog.LogBody> jsonLogList;
            LockLog.Builder logBuilder;
            this.timeoutDuration = TIME_OUT_DURATION;
            this.isFileRequest = false;
            this.isJsonRequest = false;
            this.isStringRequest = false;
            if (this.proxy == null) {
                this.proxy = BaseOkHttp.proxy;
            }
            if (this.parameter != null && !this.parameter.entrySet().isEmpty()) {
                block2: for (Map.Entry entry : this.parameter.entrySet()) {
                    if (entry.getValue() instanceof File) {
                        this.isFileRequest = true;
                        break;
                    }
                    if (!(entry.getValue() instanceof List)) continue;
                    List valueList = (List)entry.getValue();
                    for (Object value : valueList) {
                        if (!(value instanceof File)) continue;
                        this.isFileRequest = true;
                        continue block2;
                    }
                }
            }
            if (!this.isNull(this.jsonParameter)) {
                this.isJsonRequest = true;
                this.isStringRequest = false;
            }
            if (!this.isNull(this.stringParameter)) {
                this.isStringRequest = true;
                this.isJsonRequest = false;
            }
            try {
                if (this.parameter == null) {
                    this.parameter = new Parameter();
                }
                this.url = !this.requestUrl.startsWith("http") ? this.getRealRequestUrl(this.requestUrl) : this.requestUrl;
                if (this.isNull(this.url)) {
                    LockLog.Builder.create().e(">>>", "-------------------------------------").e(">>>", "\u521b\u5efa\u8bf7\u6c42\u5931\u8d25: \u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a").e(">>>", "=====================================").build();
                    return;
                }
                if (overallParameter != null && !overallParameter.entrySet().isEmpty()) {
                    for (Map.Entry entry : overallParameter.entrySet()) {
                        this.parameter.add((String)entry.getKey(), entry.getValue());
                    }
                }
                this.okHttpClient = this.createClient();
                if (this.okHttpClient == null) {
                    return;
                }
                Request request = this.createRequest();
                if (request == null) {
                    return;
                }
                if (DEBUGMODE) {
                    logBuilder = LockLog.Builder.create().i(">>>", "-------------------------------------").i(">>>", "\u521b\u5efa\u8bf7\u6c42:" + this.url).i(">>>", "\u53c2\u6570:");
                    if (this.isJsonRequest) {
                        jsonLogList = JsonFormat.formatJson(this.jsonParameter);
                        if (jsonLogList == null) {
                            logBuilder.i(">>>>>>", this.jsonParameter);
                        } else {
                            logBuilder.add(jsonLogList);
                        }
                    } else if (this.isStringRequest) {
                        logBuilder.i(">>>>>>", this.stringParameter);
                    } else {
                        logBuilder.i(">>>>>>", this.parameter.toParameterString());
                    }
                    logBuilder.i(">>>", "\u8bf7\u6c42\u5df2\u53d1\u9001 ->").build();
                }
                this.isSending = true;
                this.checkTimeOut();
                this.httpCall = this.okHttpClient.newCall(request);
                this.httpCall.enqueue(new Callback(){

                    public void onFailure(Call call, final IOException e) {
                        HttpRequest.this.deleteRequestInfo(HttpRequest.this.requestInfo);
                        if (!HttpRequest.this.isSending) {
                            return;
                        }
                        HttpRequest.this.isSending = false;
                        if (BaseOkHttp.reserveServiceUrls != null && BaseOkHttp.reserveServiceUrls.length != 0) {
                            if (BaseOkHttp.DEBUGMODE) {
                                LockLog.Builder logBuilder = LockLog.Builder.create().e(">>>", "\u670d\u52a1\u5668\uff1a" + BaseOkHttp.serviceUrl + "\u8bf7\u6c42\u5931\u8d25 \u00d7");
                                if (reserveUrlIndex != BaseOkHttp.reserveServiceUrls.length) {
                                    BaseOkHttp.serviceUrl = BaseOkHttp.reserveServiceUrls[reserveUrlIndex];
                                    reserveUrlIndex++;
                                    logBuilder.e(">>>", "\u5c1d\u8bd5\u66f4\u6362\u4e3a\u5907\u7528\u5730\u5740\u540e\u91cd\u8bd5\uff1a" + BaseOkHttp.serviceUrl);
                                    HttpRequest.this.send();
                                } else {
                                    logBuilder.e(">>>", "\u6240\u6709\u5907\u7528\u5730\u5740\u5168\u90e8\u5c1d\u8bd5\u5b8c\u6bd5\u3002\u8bf7\u6c42\u5931\u8d25 \u00d7");
                                }
                                logBuilder.e(">>>", "=====================================").build();
                            }
                        } else {
                            if (BaseOkHttp.DEBUGMODE) {
                                LockLog.Builder logBuilder = LockLog.Builder.create().e(">>>", "\u8bf7\u6c42\u5931\u8d25:" + HttpRequest.this.url).e(">>>", "\u53c2\u6570:");
                                if (HttpRequest.this.isJsonRequest) {
                                    List<LockLog.LogBody> jsonLogList = JsonFormat.formatJson(HttpRequest.this.jsonParameter);
                                    if (jsonLogList == null) {
                                        logBuilder.e(">>>>>>", HttpRequest.this.jsonParameter);
                                    } else {
                                        logBuilder.add(jsonLogList);
                                    }
                                } else if (HttpRequest.this.isStringRequest) {
                                    logBuilder.e(">>>>>>", HttpRequest.this.stringParameter);
                                } else {
                                    logBuilder.e(">>>>>>", HttpRequest.this.parameter.toParameterString());
                                }
                                if (e != null) {
                                    logBuilder.e(">>>", "\u9519\u8bef:" + LockLog.getExceptionInfo(e));
                                } else {
                                    logBuilder.e(">>>", "\u8bf7\u6c42\u53d1\u751f\u9519\u8bef: httpCall.onFailure & Exception is Null");
                                }
                                logBuilder.e(">>>", "=====================================").build();
                            }
                            HttpRequest.this.runOnMain(new Runnable(){

                                @Override
                                public void run() {
                                    if (BaseOkHttp.responseInterceptListener != null) {
                                        if (BaseOkHttp.responseInterceptListener.response((Context)HttpRequest.this.context.get(), HttpRequest.this.url, null, e) && HttpRequest.this.responseListener != null) {
                                            HttpRequest.this.responseListener.response(null, e);
                                        }
                                    } else if (HttpRequest.this.responseListener != null) {
                                        HttpRequest.this.responseListener.response(null, e);
                                    }
                                }
                            });
                        }
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        HttpRequest.this.deleteRequestInfo(HttpRequest.this.requestInfo);
                        if (!HttpRequest.this.isSending) {
                            return;
                        }
                        HttpRequest.this.isSending = false;
                        final String strResponse = response.body().string();
                        if (BaseOkHttp.DEBUGMODE) {
                            List<LockLog.LogBody> jsonLogList;
                            LockLog.Builder logBuilder = LockLog.Builder.create().i(">>>", "\u8bf7\u6c42\u6210\u529f:" + HttpRequest.this.url).i(">>>", "\u53c2\u6570:");
                            if (HttpRequest.this.isJsonRequest) {
                                jsonLogList = JsonFormat.formatJson(HttpRequest.this.jsonParameter);
                                if (jsonLogList == null) {
                                    logBuilder.i(">>>>>>", HttpRequest.this.jsonParameter);
                                } else {
                                    logBuilder.add(jsonLogList);
                                }
                            } else if (HttpRequest.this.isStringRequest) {
                                logBuilder.i(">>>>>>", HttpRequest.this.stringParameter);
                            } else {
                                logBuilder.i(">>>>>>", HttpRequest.this.parameter.toParameterString());
                            }
                            logBuilder.i(">>>", "\u8fd4\u56de\u5185\u5bb9:");
                            jsonLogList = JsonFormat.formatJson(strResponse);
                            if (jsonLogList == null) {
                                logBuilder.i(">>>", strResponse);
                            } else {
                                logBuilder.add(jsonLogList);
                            }
                            logBuilder.i(">>>", "=====================================").build();
                        }
                        HttpRequest.this.runOnMain(new Runnable(){

                            @Override
                            public void run() {
                                if (BaseOkHttp.responseInterceptListener != null) {
                                    if (BaseOkHttp.responseInterceptListener.response((Context)HttpRequest.this.context.get(), HttpRequest.this.url, strResponse, null) && HttpRequest.this.responseListener != null) {
                                        HttpRequest.this.responseListener.response(strResponse, null);
                                    }
                                } else if (HttpRequest.this.responseListener != null) {
                                    HttpRequest.this.responseListener.response(strResponse, null);
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                this.deleteRequestInfo(this.requestInfo);
                if (!DEBUGMODE) break block29;
                logBuilder = LockLog.Builder.create().e(">>>", "\u8bf7\u6c42\u521b\u5efa\u5931\u8d25:" + this.url).e(">>>", "\u53c2\u6570:");
                if (this.isJsonRequest) {
                    if (this.isStringRequest) {
                        logBuilder.e(">>>>>>", this.stringParameter);
                    } else {
                        jsonLogList = JsonFormat.formatJson(this.jsonParameter);
                        if (jsonLogList == null) {
                            logBuilder.e(">>>>>>", this.jsonParameter);
                        } else {
                            logBuilder.add(jsonLogList);
                        }
                    }
                } else if (this.parameter != null) {
                    logBuilder.e(">>>>>>", this.parameter.toParameterString());
                }
                logBuilder.e(">>>", "\u9519\u8bef:" + LockLog.getExceptionInfo(e));
                logBuilder.e(">>>", "=====================================");
                logBuilder.build();
            }
        }
    }

    private OkHttpClient createClient() {
        if (BaseOkHttp.globalCustomOkHttpClient != null) {
            return BaseOkHttp.globalCustomOkHttpClient.customBuilder(this, this.okHttpClient);
        }
        if (this.customOkHttpClient != null) {
            return this.customOkHttpClient.customBuilder(this.okHttpClient);
        }
        if (!this.skipSSLCheck && !this.isNull(SSLInAssetsFileName)) {
            File sdCache = ((Context)this.context.get()).getExternalCacheDir();
            InputStream certificates = null;
            try {
                certificates = ((Context)this.context.get()).getAssets().open(SSLInAssetsFileName);
            }
            catch (IOException e) {
                LockLog.Builder logBuilder = LockLog.Builder.create();
                logBuilder.e(">>>", "\u8bfb\u53d6SSL\u8bc1\u4e66\u9519\u8bef:" + LockLog.getExceptionInfo(e));
                logBuilder.e(">>>", "=====================================");
                logBuilder.build();
                return null;
            }
            int cacheSize = 0xA00000;
            OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(false).connectTimeout((long)this.timeoutDuration, TimeUnit.SECONDS).writeTimeout((long)this.timeoutDuration, TimeUnit.SECONDS).readTimeout((long)this.timeoutDuration, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    if (BaseOkHttp.DEBUGMODE) {
                        LockLog.logI("<<<", "hostnameVerifier: " + hostname);
                    }
                    if (BaseOkHttp.httpsVerifyServiceUrl) {
                        return BaseOkHttp.serviceUrl.contains(hostname);
                    }
                    return true;
                }
            }).cache(BaseOkHttp.requestCache ? new Cache(sdCache.getAbsoluteFile(), (long)cacheSize) : null);
            if (certificates != null) {
                builder.sslSocketFactory(HttpRequest.getSSLSocketFactory(certificates));
            }
            if (this.proxy != null) {
                builder.proxy(this.proxy);
            }
            if (autoSaveCookies) {
                builder.cookieJar(new CookieJar(){

                    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                        HttpRequest.this.cookieStore.put(url, cookies);
                        if (BaseOkHttp.DEBUGMODE) {
                            for (Cookie cookie : cookies) {
                                LockLog.logI("<<<", "saveCookie: " + cookie.name() + " path:" + cookie.path());
                            }
                        }
                    }

                    public List<Cookie> loadForRequest(HttpUrl url) {
                        List cookies = (List)HttpRequest.this.cookieStore.get(url.host());
                        return cookies != null ? cookies : new ArrayList();
                    }
                });
            }
            if (BaseOkHttp.disableOriginInterceptors) {
                builder.interceptors().clear();
                builder.networkInterceptors().clear();
            }
            return builder.build();
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(false).connectTimeout((long)this.timeoutDuration, TimeUnit.SECONDS).writeTimeout((long)this.timeoutDuration, TimeUnit.SECONDS).readTimeout((long)this.timeoutDuration, TimeUnit.SECONDS).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        if (this.proxy != null) {
            builder.proxy(this.proxy);
        }
        if (this.customOkHttpClientBuilder != null) {
            builder = this.customOkHttpClientBuilder.customBuilder(builder);
        }
        if (BaseOkHttp.globalCustomOkHttpClientBuilder != null) {
            builder = BaseOkHttp.globalCustomOkHttpClientBuilder.customBuilder(this, builder);
        }
        if (BaseOkHttp.disableOriginInterceptors) {
            builder.interceptors().clear();
            builder.networkInterceptors().clear();
        }
        return builder.build();
    }

    private Request createRequest() {
        Request.Builder builder = new Request.Builder();
        RequestBodyImpl requestBody = null;
        if (this.isFileRequest) {
            this.requestInfo = new RequestInfo(this.url, this.parameter);
            if (disallowSameRequest && this.equalsRequestInfo(this.requestInfo)) {
                return null;
            }
            this.addRequestInfo(this.requestInfo);
            if (parameterInterceptListener != null) {
                try {
                    this.parameter = parameterInterceptListener.onIntercept((Context)this.context.get(), this.url, this.parameter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (this.parameter != null && !this.parameter.entrySet().isEmpty()) {
                for (Map.Entry entry : this.parameter.entrySet()) {
                    if (entry.getValue() instanceof File) {
                        File file = (File)entry.getValue();
                        multipartBuilder.addFormDataPart((String)entry.getKey(), file.getName(), RequestBody.create((MediaType)MediaType.parse((String)this.getMimeType(file)), (File)file));
                        if (!DEBUGMODE) continue;
                        LockLog.logI(">>>", "\u6dfb\u52a0\u6587\u4ef6\uff1a" + (String)entry.getKey() + ":" + file.getName());
                        continue;
                    }
                    if (entry.getValue() instanceof List) {
                        List valueList = (List)entry.getValue();
                        for (Object value : valueList) {
                            if (value instanceof File) {
                                File file = (File)value;
                                multipartBuilder.addFormDataPart((String)entry.getKey(), file.getName(), RequestBody.create((MediaType)MediaType.parse((String)this.getMimeType(file)), (File)file));
                                if (!DEBUGMODE) continue;
                                LockLog.logI(">>>", "\u6dfb\u52a0\u6587\u4ef6\uff1a" + (String)entry.getKey() + ":" + file.getName());
                                continue;
                            }
                            multipartBuilder.addFormDataPart((String)entry.getKey(), entry.getValue() + "");
                        }
                        continue;
                    }
                    multipartBuilder.addFormDataPart((String)entry.getKey(), entry.getValue() + "");
                }
            } else {
                if (DEBUGMODE) {
                    LockLog.Builder.create().e(">>>", "-------------------------------------").e(">>>", "\u521b\u5efa\u8bf7\u6c42\u5931\u8d25:\u65e0\u4e0a\u4f20\u7684\u6587\u4ef6").e(">>>", "=====================================").build();
                }
                return null;
            }
            multipartBuilder = this.interceptMultipartBuilder(multipartBuilder);
            requestBody = new RequestBodyImpl((RequestBody)multipartBuilder.build()){

                @Override
                public void loading(long current, long total, boolean done) {
                    HttpRequest.this.uploadProgressCallback(current, total, done);
                }
            };
        } else if (this.isJsonRequest) {
            this.requestInfo = new RequestInfo(this.url, this.jsonParameter);
            if (disallowSameRequest && this.equalsRequestInfo(this.requestInfo)) {
                return null;
            }
            this.addRequestInfo(this.requestInfo);
            if (parameterInterceptListener != null) {
                try {
                    this.jsonParameter = this.jsonParameter.startsWith("[") ? parameterInterceptListener.onIntercept((Context)this.context.get(), this.url, JsonList.parse((String)this.jsonParameter)).toString() : (this.jsonParameter.startsWith("{") ? parameterInterceptListener.onIntercept((Context)this.context.get(), this.url, JsonMap.parse((String)this.jsonParameter)).toString() : parameterInterceptListener.onIntercept((Context)this.context.get(), this.url, this.jsonParameter));
                }
                catch (Exception multipartBuilder) {
                    // empty catch block
                }
            }
            if (this.isNull(this.jsonParameter)) {
                if (DEBUGMODE) {
                    LockLog.Builder.create().e(">>>", "-------------------------------------").e(">>>", "\u521b\u5efa\u8bf7\u6c42\u5931\u8d25:" + this.jsonParameter + " \u4e0d\u662f\u6b63\u786e\u7684json\u683c\u5f0f\u53c2\u6570").e(">>>", "=====================================").build();
                }
                return null;
            }
            requestBody = new RequestBodyImpl(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.jsonParameter)){

                @Override
                public void loading(long current, long total, boolean done) {
                    HttpRequest.this.uploadProgressCallback(current, total, done);
                }
            };
        } else if (this.isStringRequest) {
            this.requestInfo = new RequestInfo(this.url, this.stringParameter);
            if (disallowSameRequest && this.equalsRequestInfo(this.requestInfo)) {
                return null;
            }
            this.addRequestInfo(this.requestInfo);
            if (parameterInterceptListener != null) {
                try {
                    this.stringParameter = parameterInterceptListener.onIntercept((Context)this.context.get(), this.url, this.stringParameter);
                }
                catch (Exception multipartBuilder) {
                    // empty catch block
                }
            }
            if (this.isNull(this.stringParameter)) {
                if (DEBUGMODE) {
                    LockLog.Builder.create().e(">>>", "-------------------------------------").e(">>>", "\u521b\u5efa\u8bf7\u6c42\u5931\u8d25:" + this.stringParameter).e(">>>", "=====================================").build();
                }
                return null;
            }
            requestBody = new RequestBodyImpl(RequestBody.create((MediaType)MediaType.parse((String)"text/plain; charset=utf-8"), (String)this.stringParameter)){

                @Override
                public void loading(long current, long total, boolean done) {
                    HttpRequest.this.uploadProgressCallback(current, total, done);
                }
            };
        } else if (this.parameter != null) {
            this.requestInfo = new RequestInfo(this.url, this.parameter);
            if (disallowSameRequest && this.equalsRequestInfo(this.requestInfo)) {
                return null;
            }
            this.addRequestInfo(this.requestInfo);
            if (parameterInterceptListener != null) {
                try {
                    this.parameter = parameterInterceptListener.onIntercept((Context)this.context.get(), this.url, this.parameter);
                }
                catch (Exception multipartBuilder) {
                    // empty catch block
                }
            }
            requestBody = new RequestBodyImpl(this.parameter.toOkHttpParameter()){

                @Override
                public void loading(long current, long total, boolean done) {
                    HttpRequest.this.uploadProgressCallback(current, total, done);
                }
            };
        }
        switch (this.requestType) {
            case 1: {
                if (this.parameter != null) {
                    builder.url(this.url.contains("?") ? this.url + "&" + this.parameter.toParameterString() : this.url + "?" + this.parameter.toParameterString());
                    break;
                }
                builder.url(this.url);
                break;
            }
            case 2: {
                builder.url(this.url);
                if (requestBody == null) break;
                builder.put(requestBody);
                break;
            }
            case 3: {
                builder.url(this.url);
                if (requestBody == null) break;
                builder.delete(requestBody);
                break;
            }
            case 5: {
                builder.url(this.url);
                if (requestBody == null) break;
                builder.patch(requestBody);
                break;
            }
            default: {
                builder.url(this.url);
                if (requestBody == null) break;
                builder.post(requestBody);
            }
        }
        if (DEBUGMODE) {
            LockLog.logI(">>>", "\u6dfb\u52a0\u8bf7\u6c42\u5934:");
        }
        Parameter allHeader = new Parameter();
        if (overallHeader != null && !overallHeader.entrySet().isEmpty()) {
            allHeader.putAll(overallHeader);
        }
        if (this.headers != null && !this.headers.entrySet().isEmpty()) {
            allHeader.putAll(this.headers);
        }
        if (headerInterceptListener != null) {
            allHeader = headerInterceptListener.onIntercept((Context)this.context.get(), this.url, allHeader);
        }
        for (Map.Entry entry : allHeader.entrySet()) {
            builder.addHeader((String)entry.getKey(), entry.getValue() + "");
            if (!DEBUGMODE) continue;
            LockLog.logI(">>>>>>", (String)entry.getKey() + "=" + entry.getValue());
        }
        if (!this.isNull(this.cookieStr)) {
            builder.addHeader("Cookie", this.cookieStr);
        }
        return builder.build();
    }

    private void uploadProgressCallback(final long current, final long total, final boolean done) {
        this.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (HttpRequest.this.uploadProgressListener != null) {
                    HttpRequest.this.uploadProgressListener.onUpload(total != 0L ? (float)current * 1.0f / (float)total : 0.0f, current, total, done);
                }
            }
        });
    }

    public String getMimeType(File file) {
        if (!this.isNull(this.customMimeType)) {
            return this.customMimeType;
        }
        String suffix = HttpRequest.getSuffix(file);
        if (suffix == null) {
            return "file/*";
        }
        String type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(suffix);
        if (!this.isNull(type)) {
            return type;
        }
        return "file/*";
    }

    private static String getSuffix(File file) {
        if (file == null || !file.exists() || file.isDirectory()) {
            return null;
        }
        String fileName = file.getName();
        if (fileName.equals("") || fileName.endsWith(".")) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(index + 1).toLowerCase(Locale.US);
        }
        return null;
    }

    private String getRealRequestUrl(String url) {
        String serviceUrl = BaseOkHttp.serviceUrl;
        if (serviceUrl.endsWith("/") && url.startsWith("/")) {
            return serviceUrl + url.substring(1);
        }
        if (!serviceUrl.endsWith("/") && !url.startsWith("/")) {
            return serviceUrl + "/" + url;
        }
        return serviceUrl + url;
    }

    private void download() {
        if (this.proxy == null) {
            this.proxy = BaseOkHttp.proxy;
        }
        try {
            this.oldDownloadProgress = -1;
            if (this.isNull(this.requestUrl)) {
                LockLog.Builder.create().e(">>>", "-------------------------------------").e(">>>", "\u521b\u5efa\u8bf7\u6c42\u5931\u8d25: \u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a").e(">>>", "=====================================").build();
            }
            this.url = !this.requestUrl.startsWith("http") ? this.getRealRequestUrl(this.requestUrl) : this.requestUrl;
            this.okHttpClient = this.createClient();
            if (this.okHttpClient == null) {
                return;
            }
            Request request = this.createRequest();
            if (request == null) {
                return;
            }
            if (DEBUGMODE) {
                LockLog.Builder.create().i(">>>", "-------------------------------------").i(">>>", "\u5f00\u59cb\u4e0b\u8f7d:" + this.url).i(">>>", "=====================================").build();
            }
            this.httpCall = this.okHttpClient.newCall(request);
            this.httpCall.enqueue(new Callback(){

                public void onFailure(Call call, final IOException e) {
                    if (BaseOkHttp.DEBUGMODE) {
                        LockLog.Builder.create().e(">>>", "-------------------------------------").e(">>>", "\u4e0b\u8f7d\u5931\u8d25:" + e.getMessage()).e(">>>", "=====================================").build();
                    }
                    HttpRequest.this.runOnMain(new Runnable(){

                        @Override
                        public void run() {
                            HttpRequest.this.onDownloadListener.onDownloadFailed(e);
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(Call call, Response response) throws IOException {
                    InputStream is = null;
                    byte[] buf = new byte[2048];
                    int len = 0;
                    FileOutputStream fos = null;
                    File dir = HttpRequest.this.downloadFile.getParentFile();
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    try {
                        is = response.body().byteStream();
                        long total = response.body().contentLength();
                        fos = new FileOutputStream(HttpRequest.this.downloadFile);
                        long sum = 0L;
                        while ((len = is.read(buf)) != -1) {
                            fos.write(buf, 0, len);
                            final int progress = (int)((float)(sum += (long)len) * 1.0f / (float)total * 100.0f);
                            if (BaseOkHttp.DEBUGMODE && BaseOkHttp.DETAILSLOGS && HttpRequest.this.oldDownloadProgress != progress) {
                                LockLog.logI(">>>", "\u4e0b\u8f7d\u4e2d:" + progress);
                                HttpRequest.this.oldDownloadProgress = progress;
                            }
                            HttpRequest.this.runOnMain(new Runnable(){

                                @Override
                                public void run() {
                                    HttpRequest.this.onDownloadListener.onDownloading(progress);
                                }
                            });
                        }
                        fos.flush();
                        if (BaseOkHttp.DEBUGMODE) {
                            LockLog.Builder.create().i(">>>", "-------------------------------------").i(">>>", "\u4e0b\u8f7d\u5b8c\u6210:" + HttpRequest.this.url).i(">>>", "\u5b58\u50a8\u6587\u4ef6:" + HttpRequest.this.downloadFile.getAbsolutePath()).i(">>>", "=====================================").build();
                        }
                        HttpRequest.this.runOnMain(new Runnable(){

                            @Override
                            public void run() {
                                HttpRequest.this.onDownloadListener.onDownloadSuccess(HttpRequest.this.downloadFile);
                            }
                        });
                    }
                    catch (Exception e) {
                        if (BaseOkHttp.DEBUGMODE) {
                            LockLog.Builder.create().e(">>>", "-------------------------------------").e(">>>", "\u4e0b\u8f7d\u8fc7\u7a0b\u9519\u8bef:" + e.getMessage()).e(">>>", "=====================================").build();
                        }
                        HttpRequest.this.runOnMain(new Runnable(){

                            @Override
                            public void run() {
                                HttpRequest.this.onDownloadListener.onDownloadFailed(e);
                            }
                        });
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkTimeOut() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (HttpRequest.this.isSending) {
                    HttpRequest.this.deleteRequestInfo(HttpRequest.this.requestInfo);
                    HttpRequest.this.isSending = false;
                    if (BaseOkHttp.reserveServiceUrls != null && BaseOkHttp.reserveServiceUrls.length != 0) {
                        if (BaseOkHttp.DEBUGMODE) {
                            LockLog.Builder logBuilder = LockLog.Builder.create().e(">>>", "\u670d\u52a1\u5668\uff1a" + BaseOkHttp.serviceUrl + "\u8bf7\u6c42\u8d85\u65f6 \u00d7");
                            if (reserveUrlIndex != BaseOkHttp.reserveServiceUrls.length) {
                                BaseOkHttp.serviceUrl = BaseOkHttp.reserveServiceUrls[reserveUrlIndex];
                                reserveUrlIndex++;
                                logBuilder.e(">>>", "\u5c1d\u8bd5\u66f4\u6362\u4e3a\u5907\u7528\u5730\u5740\u540e\u91cd\u8bd5\uff1a" + BaseOkHttp.serviceUrl);
                                HttpRequest.this.send();
                            } else {
                                logBuilder.e(">>>", "\u6240\u6709\u5907\u7528\u5730\u5740\u5168\u90e8\u5c1d\u8bd5\u5b8c\u6bd5\u3002\u8bf7\u6c42\u8d85\u65f6 \u00d7");
                            }
                            logBuilder.e(">>>", "=====================================");
                            logBuilder.build();
                        }
                    } else {
                        if (BaseOkHttp.DEBUGMODE) {
                            LockLog.Builder.create().e(">>>", "\u8bf7\u6c42\u8d85\u65f6 \u00d7").e(">>>", "=====================================").build();
                        }
                        HttpRequest.this.runOnMain(new Runnable(){

                            @Override
                            public void run() {
                                if (BaseOkHttp.responseInterceptListener == null) {
                                    if (HttpRequest.this.responseListener != null) {
                                        HttpRequest.this.responseListener.response(null, new TimeOutException());
                                    }
                                } else if (BaseOkHttp.responseInterceptListener.response((Context)HttpRequest.this.context.get(), HttpRequest.this.url, null, new TimeOutException()) && HttpRequest.this.responseListener != null) {
                                    HttpRequest.this.responseListener.response(null, new TimeOutException());
                                }
                            }
                        });
                    }
                }
            }
        }, this.timeoutDuration * 1000);
    }

    private static SSLSocketFactory getSSLSocketFactory(InputStream ... certificates) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            int index = 0;
            for (InputStream certificate : certificates) {
                String certificateAlias = Integer.toString(index++);
                keyStore.setCertificateEntry(certificateAlias, certificateFactory.generateCertificate(certificate));
                try {
                    if (certificate == null) continue;
                    certificate.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isNull(String s) {
        return s == null || s.trim().isEmpty() || "null".equals(s) || "(null)".equals(s);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public HttpRequest setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    private HttpRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRequest build(Context context, String url) {
        Class<HttpRequest> clazz = HttpRequest.class;
        synchronized (HttpRequest.class) {
            HttpRequest httpRequest = new HttpRequest();
            httpRequest.context = new WeakReference<Context>(context);
            httpRequest.requestUrl = url;
            httpRequest.httpRequest = httpRequest;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return httpRequest;
        }
    }

    public HttpRequest addParameter(String key, Object value) {
        if (this.parameter == null) {
            this.parameter = new Parameter();
        }
        this.parameter.add(key, value);
        this.jsonParameter = null;
        this.stringParameter = null;
        return this;
    }

    public HttpRequest setParameter(Parameter parameter) {
        this.parameter = parameter;
        this.jsonParameter = null;
        this.stringParameter = null;
        return this;
    }

    public HttpRequest setStringParameter(String stringParameter) {
        this.stringParameter = stringParameter;
        this.parameter = null;
        return this;
    }

    public HttpRequest setJsonParameter(String jsonParameter) {
        this.jsonParameter = jsonParameter;
        return this;
    }

    public HttpRequest setJsonParameter(JsonMap jsonParameter) {
        this.jsonParameter = jsonParameter == null ? null : jsonParameter.toString();
        return this;
    }

    public HttpRequest setJsonParameter(JsonList jsonParameter) {
        this.jsonParameter = jsonParameter == null ? null : jsonParameter.toString();
        return this;
    }

    public HttpRequest addHeaders(String key, String value) {
        if (this.headers == null) {
            this.headers = new Parameter();
        }
        this.headers.add(key, value);
        return this;
    }

    public HttpRequest setHeaders(Parameter headers) {
        this.headers = headers;
        return this;
    }

    public HashMap<HttpUrl, List<Cookie>> getCookies() {
        return this.cookieStore;
    }

    public HttpRequest cleanCookies() {
        this.cookieStore = new HashMap();
        return this;
    }

    public HttpRequest setUrl(String url) {
        this.requestUrl = url;
        return this;
    }

    public HttpRequest setResponseListener(ResponseListener listener) {
        this.responseListener = listener;
        return this;
    }

    public HttpRequest setJsonResponseListener(JsonResponseListener jsonResponseListener) {
        this.responseListener = jsonResponseListener;
        return this;
    }

    public void doPost() {
        this.requestType = 0;
        this.send();
    }

    public void doPatch() {
        this.requestType = 5;
        this.send();
    }

    public void doGet() {
        this.requestType = 1;
        this.send();
    }

    public void doDelete() {
        this.requestType = 3;
        this.send();
    }

    public void doPut() {
        this.requestType = 2;
        this.send();
    }

    public void doDownload(File downloadFile, OnDownloadListener onDownloadListener) {
        this.requestType = 4;
        this.downloadFile = downloadFile;
        this.onDownloadListener = onDownloadListener;
        this.download();
    }

    public String getCookie() {
        return this.cookieStr;
    }

    public HttpRequest setCookie(String cookie) {
        this.cookieStr = this.cookieStr;
        return this;
    }

    @Deprecated
    public HttpRequest setMediaType(MediaType mediaType) {
        return this;
    }

    public HttpRequest setCustomMimeType(String customMimeType) {
        this.customMimeType = customMimeType;
        return this;
    }

    public String getCustomMimeType() {
        return this.customMimeType;
    }

    public HttpRequest skipSSLCheck() {
        this.skipSSLCheck = true;
        return this;
    }

    public File getDownloadFile() {
        return this.downloadFile;
    }

    public void stop() {
        if (this.httpCall != null) {
            this.httpCall.cancel();
        }
    }

    private void runOnMain(Runnable runnable) {
        if (this.context == null || this.context.get() == null) {
            this.stop();
            return;
        }
        if (this.context.get() instanceof Activity) {
            if (((Activity)this.context.get()).isFinishing()) {
                this.stop();
                return;
            }
            ((Activity)this.context.get()).runOnUiThread(runnable);
        } else {
            if (DEBUGMODE && DETAILSLOGS) {
                LockLog.logI(">>>", "context \u4e0d\u662f Activity\uff0c\u672c\u6b21\u8bf7\u6c42\u5728\u5f02\u6b65\u7ebf\u7a0b\u8fd4\u56de >>>");
            }
            runnable.run();
        }
    }

    public void onDetach() {
        this.context.clear();
    }

    public int getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public HttpRequest setTimeoutDuration(int timeoutDuration) {
        this.timeoutDuration = timeoutDuration;
        return this;
    }

    public UploadProgressListener getUploadProgressListener() {
        return this.uploadProgressListener;
    }

    public HttpRequest setUploadProgressListener(UploadProgressListener uploadProgressListener) {
        this.uploadProgressListener = uploadProgressListener;
        return this;
    }

    protected MultipartBody.Builder interceptMultipartBuilder(MultipartBody.Builder multipartBuilder) {
        if (this.multipartBuilderInterceptor != null) {
            multipartBuilder = this.multipartBuilderInterceptor.interceptMultipartBuilder(multipartBuilder);
        }
        return multipartBuilder;
    }

    public MultipartBuilderInterceptor getMultipartBuilderInterceptor() {
        return this.multipartBuilderInterceptor;
    }

    public HttpRequest setMultipartBuilderInterceptor(MultipartBuilderInterceptor multipartBuilderInterceptor) {
        this.multipartBuilderInterceptor = multipartBuilderInterceptor;
        return this;
    }

    public CustomOkHttpClient getCustomOkHttpClient() {
        return this.customOkHttpClient;
    }

    public HttpRequest setCustomOkHttpClient(CustomOkHttpClient customOkHttpClient) {
        this.customOkHttpClient = customOkHttpClient;
        return this;
    }

    public CustomOkHttpClientBuilder getCustomOkHttpClientBuilder() {
        return this.customOkHttpClientBuilder;
    }

    public HttpRequest setCustomOkHttpClientBuilder(CustomOkHttpClientBuilder customOkHttpClientBuilder) {
        this.customOkHttpClientBuilder = customOkHttpClientBuilder;
        return this;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public String getUrl() {
        return this.url;
    }

    public String getJsonParameter() {
        return this.jsonParameter;
    }

    public String getStringParameter() {
        return this.stringParameter;
    }

    public boolean isFileRequest() {
        return this.isFileRequest;
    }

    public boolean isJsonRequest() {
        return this.isJsonRequest;
    }

    public boolean isStringRequest() {
        return this.isStringRequest;
    }
}

