/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.baseokhttp;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.kongzue.baseokhttp.listener.WebSocketStatusListener;
import com.kongzue.baseokhttp.util.BaseOkHttp;
import java.lang.ref.WeakReference;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class BaseWebSocket {
    public static final int CONNECTING = 0;
    public static final int CONNECTED = 1;
    public static final int RECONNECT = 2;
    public static final int DISCONNECTED = -1;
    public static final int BREAK_NORMAL = 0;
    public static final int BREAK_ABNORMAL = 1;
    private WeakReference<Context> context;
    private String url;
    private WebSocket webSocket;
    private OkHttpClient okHttpClient;
    private Request request;
    private int status = -1;
    private boolean autoReconnect = true;
    private boolean manualClose = false;
    private WebSocketStatusListener webSocketStatusListener;
    private int reconnectCount = 0;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private Runnable reconnectRunnable = new Runnable(){

        @Override
        public void run() {
            if (BaseWebSocket.this.webSocketStatusListener != null) {
                BaseWebSocket.this.webSocketStatusListener.onReconnect();
            }
            BaseWebSocket.this.buildConnect();
        }
    };
    private WebSocketListener webSocketListener = new WebSocketListener(){

        public void onOpen(WebSocket ws, final Response response) {
            BaseWebSocket.this.logd("\u5df2\u5efa\u7acb\u8fde\u63a5");
            BaseWebSocket.this.webSocket = ws;
            BaseWebSocket.this.status = 1;
            BaseWebSocket.this.reconnectCount = 0;
            BaseWebSocket.this.mainHandler.removeCallbacks(BaseWebSocket.this.reconnectRunnable);
            if (BaseWebSocket.this.webSocketStatusListener != null) {
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    BaseWebSocket.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseWebSocket.this.webSocketStatusListener.connected(response);
                        }
                    });
                } else {
                    BaseWebSocket.this.webSocketStatusListener.connected(response);
                }
            }
        }

        public void onMessage(WebSocket webSocket, final String text) {
            BaseWebSocket.this.logd("\u63a5\u6536\u5230\u6d88\u606f:" + text);
            if (BaseWebSocket.this.webSocketStatusListener != null) {
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    BaseWebSocket.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseWebSocket.this.webSocketStatusListener.onMessage(text);
                        }
                    });
                } else {
                    BaseWebSocket.this.webSocketStatusListener.onMessage(text);
                }
            }
        }

        public void onMessage(WebSocket webSocket, final ByteString bytes) {
            BaseWebSocket.this.logd("\u63a5\u6536\u5230\u6d88\u606f:" + bytes);
            if (BaseWebSocket.this.webSocketStatusListener != null) {
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    BaseWebSocket.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseWebSocket.this.webSocketStatusListener.onMessage(bytes);
                        }
                    });
                } else {
                    BaseWebSocket.this.webSocketStatusListener.onMessage(bytes);
                }
            }
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            BaseWebSocket.this.logd("\u8fde\u63a5\u6b63\u5728\u65ad\u5f00:" + code);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            BaseWebSocket.this.logd("\u8fde\u63a5\u5df2\u65ad\u5f00:" + code);
            if (BaseWebSocket.this.webSocketStatusListener != null) {
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    BaseWebSocket.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseWebSocket.this.webSocketStatusListener.onDisconnected(0);
                        }
                    });
                } else {
                    BaseWebSocket.this.webSocketStatusListener.onDisconnected(0);
                }
            }
        }

        public void onFailure(WebSocket webSocket, final Throwable t, Response response) {
            if (BaseWebSocket.this.status == -1) {
                BaseWebSocket.this.logd("\u8fde\u63a5\u5df2\u65ad\u5f00");
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    BaseWebSocket.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BaseWebSocket.this.webSocketStatusListener.onDisconnected(1);
                        }
                    });
                } else {
                    BaseWebSocket.this.webSocketStatusListener.onDisconnected(1);
                }
                return;
            }
            try {
                BaseWebSocket.this.loge("\u8fde\u63a5\u5931\u8d25");
                BaseWebSocket.this.reConnect();
                if (BaseWebSocket.this.webSocketStatusListener != null) {
                    if (Looper.myLooper() != Looper.getMainLooper()) {
                        BaseWebSocket.this.mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                BaseWebSocket.this.webSocketStatusListener.onConnectionFailed(t);
                            }
                        });
                    } else {
                        BaseWebSocket.this.webSocketStatusListener.onConnectionFailed(t);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseWebSocket BUILD(Context context, String url) {
        Class<BaseWebSocket> clazz = BaseWebSocket.class;
        synchronized (BaseWebSocket.class) {
            BaseWebSocket baseWebSocket = new BaseWebSocket();
            baseWebSocket.context = new WeakReference<Context>(context);
            baseWebSocket.url = url;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return baseWebSocket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseWebSocket BUILD(Context context, String url, OkHttpClient okHttpClient) {
        Class<BaseWebSocket> clazz = BaseWebSocket.class;
        synchronized (BaseWebSocket.class) {
            BaseWebSocket baseWebSocket = new BaseWebSocket();
            baseWebSocket.context = new WeakReference<Context>(context);
            baseWebSocket.url = url;
            baseWebSocket.okHttpClient = okHttpClient;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return baseWebSocket;
        }
    }

    private void doConnect() {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient.Builder().retryOnConnectionFailure(true).build();
        }
        if (this.request == null) {
            this.request = new Request.Builder().url(this.url).build();
        }
        this.okHttpClient.dispatcher().cancelAll();
        this.okHttpClient.newWebSocket(this.request, this.webSocketListener);
    }

    public BaseWebSocket startConnect() {
        this.manualClose = false;
        this.buildConnect();
        return this;
    }

    private void buildConnect() {
        if (!this.isNetworkConnected((Context)this.context.get())) {
            this.status = -1;
        }
        if (this.status != 1 && this.status != 0) {
            this.status = 0;
            this.doConnect();
        }
    }

    public void reConnect() {
        this.manualClose = true;
        if (!this.autoReconnect | this.manualClose) {
            return;
        }
        if (BaseOkHttp.DEBUGMODE) {
            this.loge("\u91cd\u8fde\u6b21\u6570\uff1a" + this.reconnectCount);
        }
        if (!this.isNetworkConnected((Context)this.context.get())) {
            this.status = -1;
            this.loge("\u7f51\u7edc\u9519\u8bef");
        }
        this.status = 2;
        long delay = this.reconnectCount * BaseOkHttp.websocketReconnectInterval * 1000;
        this.mainHandler.postDelayed(this.reconnectRunnable, delay);
        ++this.reconnectCount;
    }

    public void disConnect() {
        block6: {
            if (this.status == -1) {
                return;
            }
            if (this.okHttpClient != null) {
                this.okHttpClient.dispatcher().cancelAll();
            }
            if (this.webSocket != null) {
                try {
                    boolean isClosed = this.webSocket.close(1000, "normal close");
                    if (!isClosed && this.webSocketStatusListener != null) {
                        this.webSocketStatusListener.onDisconnected(1);
                    }
                }
                catch (Exception e) {
                    if (this.webSocketStatusListener == null) break block6;
                    this.webSocketStatusListener.onDisconnected(1);
                }
            }
        }
        this.status = -1;
    }

    public boolean send(String msg) {
        return this.sendMsg(msg);
    }

    public boolean send(ByteString byteString) {
        return this.sendMsg(byteString);
    }

    private boolean sendMsg(Object msg) {
        boolean isSend = false;
        if (this.webSocket != null && this.status == 1) {
            if (msg instanceof String) {
                isSend = this.webSocket.send((String)msg);
            } else if (msg instanceof ByteString) {
                isSend = this.webSocket.send((ByteString)msg);
            }
            if (!isSend) {
                this.loge("\u53d1\u9001\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u8fde...");
                this.reConnect();
            }
        } else {
            this.loge("\u672a\u5efa\u7acb\u8fde\u63a5\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
        }
        return isSend;
    }

    public BaseWebSocket setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public BaseWebSocket setWebSocketStatusListener(WebSocketStatusListener webSocketStatusListener) {
        this.webSocketStatusListener = webSocketStatusListener;
        return this;
    }

    public int getReconnectCount() {
        return this.reconnectCount;
    }

    private boolean isNetworkConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return mNetworkInfo.isAvailable();
        }
        return false;
    }

    public int getStatus() {
        return this.status;
    }

    private void logd(String s) {
        if (BaseOkHttp.DEBUGMODE) {
            Log.d((String)">>>", (String)s);
        }
    }

    private void loge(String s) {
        if (BaseOkHttp.DEBUGMODE) {
            Log.e((String)">>>", (String)s);
        }
    }

    public void onDetach() {
        this.context.clear();
    }
}

