/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kongchen.swagger.docgen.GenerateException;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.util.Json;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;

public class SecurityDefinition {
    private String name;
    private String type;
    private String in;
    private String description;
    private String json;
    private String jsonPath;
    private ObjectMapper mapper = Json.mapper();

    public Map<String, SecuritySchemeDefinition> generateSecuritySchemeDefinitions() throws GenerateException {
        HashMap<String, SecuritySchemeDefinition> map = new HashMap<String, SecuritySchemeDefinition>();
        Map<Object, Object> securityDefinitions = new HashMap();
        if (this.json != null || this.jsonPath != null) {
            securityDefinitions = this.loadSecurityDefintionsFromJsonFile();
        } else {
            JsonNode tree = this.mapper.valueToTree((Object)this);
            securityDefinitions.put(tree.get("name").asText(), tree);
        }
        for (Map.Entry<Object, Object> securityDefinition : securityDefinitions.entrySet()) {
            JsonNode definition = (JsonNode)securityDefinition.getValue();
            SecuritySchemeDefinition ssd = this.getSecuritySchemeDefinitionByType(definition.get("type").asText(), definition);
            this.tryFillNameField(ssd, (String)securityDefinition.getKey());
            if (ssd == null) continue;
            map.put((String)securityDefinition.getKey(), ssd);
        }
        return map;
    }

    private void tryFillNameField(SecuritySchemeDefinition ssd, String value) {
        if (ssd == null) {
            return;
        }
        Field nameField = FieldUtils.getField(ssd.getClass(), (String)"name", (boolean)true);
        try {
            if (nameField != null && nameField.get(ssd) == null) {
                nameField.set(ssd, value);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private Map<String, JsonNode> loadSecurityDefintionsFromJsonFile() throws GenerateException {
        HashMap<String, JsonNode> securityDefinitions = new HashMap<String, JsonNode>();
        try {
            InputStream jsonStream = this.json != null ? this.getClass().getResourceAsStream(this.json) : new FileInputStream(this.jsonPath);
            JsonNode tree = this.mapper.readTree(jsonStream);
            Iterator fields = tree.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode securityDefinition = (JsonNode)field.getValue();
                securityDefinitions.put((String)field.getKey(), securityDefinition);
            }
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
        return securityDefinitions;
    }

    private SecuritySchemeDefinition getSecuritySchemeDefinitionByType(String type, JsonNode node) throws GenerateException {
        try {
            OAuth2Definition def = null;
            if (type.equals(new OAuth2Definition().getType())) {
                def = new OAuth2Definition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)this.mapper.readValue(node.traverse(), OAuth2Definition.class);
                }
            } else if (type.equals(new BasicAuthDefinition().getType())) {
                def = new BasicAuthDefinition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)this.mapper.readValue(node.traverse(), BasicAuthDefinition.class);
                }
            } else if (type.equals(new ApiKeyAuthDefinition().getType())) {
                def = new ApiKeyAuthDefinition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)this.mapper.readValue(node.traverse(), ApiKeyAuthDefinition.class);
                }
            }
            return def;
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIn() {
        return this.in;
    }

    public void setIn(String in) {
        this.in = in;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }
}

