/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.spring;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.annotations.ApiParam;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public class SpringSwaggerExtension
extends AbstractSwaggerExtension {
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        String defaultValue = "";
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Parameter parameter = null;
        for (Annotation annotation : annotations) {
            if (annotation instanceof ModelAttribute) {
                parameters.addAll(this.extractParametersFromModelAttributeAnnotation(annotation, type));
            } else {
                parameter = this.extractParameterFromAnnotation(annotation, defaultValue, type);
            }
            if (parameter == null) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    private Parameter extractParameterFromAnnotation(Annotation annotation, String defaultValue, Type type) {
        PathParameter parameter = null;
        if (annotation instanceof RequestParam) {
            Property schema;
            RequestParam requestParam = (RequestParam)annotation;
            String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestParam.value(), (CharSequence)requestParam.name());
            QueryParameter queryParameter = (QueryParameter)((QueryParameter)new QueryParameter().name(paramName)).required(requestParam.required());
            if (!defaultValue.isEmpty()) {
                queryParameter.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                queryParameter.setProperty(schema);
            }
            parameter = queryParameter;
        } else if (annotation instanceof PathVariable) {
            Property schema;
            PathVariable pathVariable = (PathVariable)annotation;
            String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)pathVariable.value(), (CharSequence)pathVariable.name());
            PathParameter pathParameter = (PathParameter)new PathParameter().name(paramName);
            if (!defaultValue.isEmpty()) {
                pathParameter.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                pathParameter.setProperty(schema);
            }
            parameter = pathParameter;
        } else if (annotation instanceof RequestHeader) {
            RequestHeader requestHeader = (RequestHeader)annotation;
            String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestHeader.value(), (CharSequence)requestHeader.name());
            HeaderParameter headerParameter = (HeaderParameter)((HeaderParameter)new HeaderParameter().name(paramName)).required(requestHeader.required());
            headerParameter.setDefaultValue(defaultValue);
            Property schema = ModelConverters.getInstance().readAsProperty(type);
            if (schema != null) {
                headerParameter.setProperty(schema);
            }
            parameter = headerParameter;
        } else if (annotation instanceof CookieValue) {
            Property schema;
            CookieValue cookieValue = (CookieValue)annotation;
            String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)cookieValue.value(), (CharSequence)cookieValue.name());
            CookieParameter cookieParameter = (CookieParameter)((CookieParameter)new CookieParameter().name(paramName)).required(cookieValue.required());
            if (!defaultValue.isEmpty()) {
                cookieParameter.setDefaultValue(defaultValue);
            }
            if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
                cookieParameter.setProperty(schema);
            }
            parameter = cookieParameter;
        } else if (annotation instanceof RequestPart) {
            JavaType ct;
            Object schema;
            RequestPart requestPart = (RequestPart)annotation;
            String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestPart.value(), (CharSequence)requestPart.name());
            FormParameter formParameter = (FormParameter)((FormParameter)new FormParameter().name(paramName)).required(requestPart.required());
            if (!defaultValue.isEmpty()) {
                formParameter.setDefaultValue(defaultValue);
            }
            if ((schema = MultipartFile.class.isAssignableFrom((ct = this.constructType(type)).getRawClass()) ? new FileProperty() : (ct.isContainerType() && MultipartFile.class.isAssignableFrom(ct.getContentType().getRawClass()) ? new ArrayProperty().items((Property)new FileProperty()) : ModelConverters.getInstance().readAsProperty(type))) != null) {
                formParameter.setProperty((Property)schema);
            }
            parameter = formParameter;
        }
        return parameter;
    }

    private List<Parameter> extractParametersFromModelAttributeAnnotation(Annotation annotation, Type type) {
        if (!(annotation instanceof ModelAttribute)) {
            return null;
        }
        Class cls = TypeUtils.getRawType((Type)type, (Type)type);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors((Class)cls)) {
            Class<?> parameterClass;
            Annotation firstMethodParameterAnnotation;
            Annotation[][] methodAnnotations;
            ApiParam propertySetterApiParam;
            Method propertyDescriptorSetter = propertyDescriptor.getWriteMethod();
            if (propertyDescriptorSetter == null || (propertySetterApiParam = (ApiParam)AnnotationUtils.findAnnotation((Method)propertyDescriptorSetter, ApiParam.class)) == null || (methodAnnotations = propertyDescriptorSetter.getParameterAnnotations()) == null || methodAnnotations.length == 0) continue;
            String defaultValue = "";
            Parameter propertySetterExtractedParameter = null;
            Annotation[] annotationArray = methodAnnotations[0];
            int n = annotationArray.length;
            for (int i = 0; i < n && (propertySetterExtractedParameter = this.extractParameterFromAnnotation(firstMethodParameterAnnotation = annotationArray[i], defaultValue, parameterClass = propertyDescriptor.getPropertyType())) == null; ++i) {
            }
            if (propertySetterExtractedParameter == null) {
                QueryParameter queryParameter = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name(propertyDescriptor.getDisplayName())).description(propertySetterApiParam.value())).required(propertySetterApiParam.required());
                queryParameter.setAccess(propertySetterApiParam.access());
                Property schema = ModelConverters.getInstance().readAsProperty(propertyDescriptor.getPropertyType());
                if (schema != null) {
                    queryParameter.setProperty(schema);
                }
                if (!propertySetterApiParam.name().isEmpty()) {
                    queryParameter.setName(propertySetterApiParam.name());
                }
                parameters.add((Parameter)queryParameter);
                continue;
            }
            parameters.add(propertySetterExtractedParameter);
        }
        return parameters;
    }

    public boolean shouldIgnoreType(Type type, Set<Type> typesToSkip) {
        Class cls = TypeUtils.getRawType((Type)type, (Type)type);
        return cls != null && cls.getName().startsWith("org.springframework") && !cls.getName().equals("org.springframework.web.multipart.MultipartFile");
    }
}

