/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

public class SpringExceptionHandlerReader {
    private final Log log;
    private Map<Class<? extends Throwable>, ResponseStatus> exceptionMapping = new HashMap<Class<? extends Throwable>, ResponseStatus>();

    public SpringExceptionHandlerReader(Log log) {
        this.log = log;
    }

    public void processExceptionHandlers(Set<Class<?>> classes) {
        this.exceptionMapping = this.generateExceptionMapping(classes);
    }

    protected Map<Class<? extends Throwable>, ResponseStatus> generateExceptionMapping(Set<Class<?>> classes) {
        HashMap<Class<? extends Throwable>, ResponseStatus> result = new HashMap<Class<? extends Throwable>, ResponseStatus>();
        this.log.debug((CharSequence)String.format("Looking for classes with @ControllerAdvice annotation", new Object[0]));
        for (Class<?> clazz : classes) {
            ControllerAdvice advice = (ControllerAdvice)AnnotationUtils.findAnnotation(clazz, ControllerAdvice.class);
            if (advice == null) continue;
            this.log.debug((CharSequence)String.format("%s is annotated as @ControllerAdvice", clazz.getName()));
            for (Method method : clazz.getMethods()) {
                Class[] exceptionClasses;
                ExceptionHandler handler = (ExceptionHandler)AnnotationUtils.findAnnotation((Method)method, ExceptionHandler.class);
                if (handler == null) {
                    this.log.debug((CharSequence)String.format("@ExceptionHandler is missing on %s method, skipping", method));
                    continue;
                }
                ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation((Method)method, ResponseStatus.class);
                if (responseStatus == null) {
                    this.log.debug((CharSequence)String.format("@ResponseStatus is missing on %s method, skipping", method));
                    continue;
                }
                for (Class exceptionClass : exceptionClasses = handler.value()) {
                    this.log.debug((CharSequence)String.format("%s will be mapped to %s", exceptionClass, responseStatus));
                    result.put(exceptionClass, responseStatus);
                }
            }
        }
        return result;
    }

    protected List<ResponseStatus> getResponseStatusesFromExceptions(Method method) {
        LinkedList<ResponseStatus> result = new LinkedList<ResponseStatus>();
        for (Class<?> exceptionClass : method.getExceptionTypes()) {
            ResponseStatus responseStatus = this.exceptionMapping.get(exceptionClass);
            if (null == responseStatus) {
                responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(exceptionClass, ResponseStatus.class);
            }
            if (null == responseStatus) continue;
            result.add(responseStatus);
        }
        return result;
    }
}

