/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mustache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.kongchen.swagger.docgen.TypeUtils;
import com.github.kongchen.swagger.docgen.mustache.MustacheApi;
import com.github.kongchen.swagger.docgen.mustache.MustacheItem;
import com.github.kongchen.swagger.docgen.mustache.MustacheParameter;
import com.github.kongchen.swagger.docgen.mustache.MustacheParameterSet;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationParameter;
import com.wordnik.swagger.core.DocumentationSchema;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MustacheDocument
implements Comparable<MustacheDocument> {
    protected static final String VOID = "void";
    protected static final String ARRAY = "Array";
    protected static final String ANY = "any";
    @JsonIgnore
    private final HashMap<String, DocumentationSchema> models;
    private int index;
    String resourcePath;
    String description;
    List<MustacheApi> apis = new LinkedList<MustacheApi>();
    @JsonIgnore
    private Set<String> requestTypes = new LinkedHashSet<String>();
    @JsonIgnore
    private Set<String> responseTypes = new LinkedHashSet<String>();
    @JsonIgnore
    private int apiIndex = 1;

    public MustacheDocument(Documentation swaggerDoc) {
        this.models = swaggerDoc.getModels();
        this.resourcePath = swaggerDoc.getResourcePath();
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getDescription() {
        return this.description;
    }

    public List<MustacheApi> getApis() {
        return this.apis;
    }

    public Set<String> getRequestTypes() {
        return this.requestTypes;
    }

    public Set<String> getResponseTypes() {
        return this.responseTypes;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void addApi(MustacheApi wapi) {
        wapi.apiIndex = this.apiIndex++;
        this.apis.add(wapi);
    }

    public void addResponseType(String trueType) {
        if (trueType != null) {
            this.responseTypes.add(trueType);
        }
    }

    public List<MustacheParameterSet> analyzeParameters(List<DocumentationParameter> parameters) {
        if (parameters == null) {
            return null;
        }
        LinkedList<MustacheParameterSet> list = new LinkedList<MustacheParameterSet>();
        Map<String, List<MustacheParameter>> paraMap = this.toParameterTypeMap(parameters);
        for (Map.Entry<String, List<MustacheParameter>> entry : paraMap.entrySet()) {
            list.add(new MustacheParameterSet(entry));
        }
        return list;
    }

    private Map<String, List<MustacheParameter>> toParameterTypeMap(List<DocumentationParameter> parameters) {
        HashMap<String, List<MustacheParameter>> paraMap = new HashMap<String, List<MustacheParameter>>();
        for (DocumentationParameter para : parameters) {
            MustacheParameter mustacheParameter = this.analyzeParameter(para);
            LinkedList<MustacheParameter> paraList = (LinkedList<MustacheParameter>)paraMap.get(para.getParamType());
            if (paraList == null) {
                paraList = new LinkedList<MustacheParameter>();
                paraMap.put(para.getParamType(), paraList);
            }
            paraList.add(mustacheParameter);
        }
        return paraMap;
    }

    private MustacheParameter analyzeParameter(DocumentationParameter para) {
        MustacheParameter mustacheParameter = new MustacheParameter(para);
        if (this.models != null && this.models.get(mustacheParameter.linkType) == null) {
            mustacheParameter.setName(para.getName());
        } else {
            if (mustacheParameter.getLinkType() != null && !para.getParamType().equals("header")) {
                this.requestTypes.add(mustacheParameter.getLinkType());
            }
            if (para.getName() != null) {
                mustacheParameter.setName(para.getName());
            } else {
                mustacheParameter.setName(para.getDataType());
            }
        }
        return mustacheParameter;
    }

    public List<MustacheItem> analyzeDataTypes(String responseClass) {
        if (responseClass == null || responseClass.equals(VOID) || this.models == null) {
            return null;
        }
        LinkedList<MustacheItem> mustacheItemList = new LinkedList<MustacheItem>();
        DocumentationSchema field = this.models.get(TypeUtils.upperCaseFirstCharacter(responseClass));
        if (field != null && field.getProperties() != null) {
            for (Map.Entry entry : field.getProperties().entrySet()) {
                MustacheItem mustacheItem = new MustacheItem((String)entry.getKey(), (DocumentationSchema)entry.getValue());
                DocumentationSchema item = ((DocumentationSchema)entry.getValue()).getItems();
                if (this.models.get(mustacheItem.getType()) != null) {
                    this.responseTypes.add(mustacheItem.getType());
                } else if (mustacheItem.getType().equalsIgnoreCase(ARRAY)) {
                    this.handleArrayType(mustacheItem, item);
                }
                mustacheItemList.add(mustacheItem);
            }
        }
        return mustacheItemList;
    }

    private void handleArrayType(MustacheItem mustacheItem, DocumentationSchema item) {
        if (item != null) {
            if (item.getType().equals(ANY) && item.ref() != null) {
                mustacheItem.setTypeAsArray(item.ref());
                this.responseTypes.add(item.ref());
            } else {
                mustacheItem.setTypeAsArray(item.getType());
            }
        }
    }

    @Override
    public int compareTo(MustacheDocument o) {
        if (o == null) {
            return 1;
        }
        return this.getResourcePath().compareTo(o.getResourcePath());
    }
}

