/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.mavenplugin.MavenDocumentSource;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ApiDocumentMojo
extends AbstractMojo {
    private List<ApiSource> apiSources;

    public List<ApiSource> getApiSources() {
        return this.apiSources;
    }

    public void setApiSources(List<ApiSource> apiSources) {
        this.apiSources = apiSources;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().debug((CharSequence)this.apiSources.toString());
            for (ApiSource apiSource : this.apiSources) {
                File outputDirectory = new File(apiSource.getOutputPath()).getParentFile();
                if (outputDirectory != null && !outputDirectory.exists() && !outputDirectory.mkdirs()) {
                    throw new MojoExecutionException("Create directory[" + apiSource.getOutputPath() + "] for output failed.");
                }
                MavenDocumentSource documentSource = new MavenDocumentSource(apiSource, this.getLog());
                ((AbstractDocumentSource)documentSource).loadDocuments();
                documentSource.toDocuments();
                documentSource.toSwaggerDocuments();
            }
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage());
        }
        catch (GenerateException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

