/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.wallet;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kethereum.crypto.ConvertersKt;
import org.kethereum.crypto.CryptoAPI;
import org.kethereum.crypto.SecureRandomUtils;
import org.kethereum.crypto.api.cipher.AESCipher;
import org.kethereum.crypto.impl.hashing.DigestParams;
import org.kethereum.crypto.impl.kdf.PBKDF2;
import org.kethereum.crypto.impl.kdf.SCrypt;
import org.kethereum.extensions.BigIntegerKt;
import org.kethereum.keccakshortcut.KeccakKt;
import org.kethereum.model.ECKeyPair;
import org.kethereum.model.PrivateKey;
import org.kethereum.wallet.model.Aes128CtrKdfParams;
import org.kethereum.wallet.model.CipherException;
import org.kethereum.wallet.model.CipherParams;
import org.kethereum.wallet.model.InvalidPasswordException;
import org.kethereum.wallet.model.KdfParams;
import org.kethereum.wallet.model.ScryptConfig;
import org.kethereum.wallet.model.ScryptKdfParams;
import org.kethereum.wallet.model.Wallet;
import org.kethereum.wallet.model.WalletCrypto;
import org.kethereum.wallet.model.WalletForImport;
import org.komputing.khex.extensions.ByteArrayExtensionsKt;
import org.komputing.khex.extensions.HexStringExtensionsKt;
import org.komputing.khex.model.HexString;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0018H\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0003H\u0000\u001a(\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014H\u0002\u001a\u001a\u0010\u000f\u001a\u00020\u0010*\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0006\u001a\u0012\u0010(\u001a\u00020\u0012*\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u000e\u0010)\u001a\u0004\u0018\u00010**\u00020+H\u0000\u001a\f\u0010,\u001a\u00020\u0010*\u00020+H\u0000\u001a\n\u0010-\u001a\u00020.*\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"CIPHER", "", "CURRENT_VERSION", "", "DKLEN", "LIGHT_SCRYPT_CONFIG", "Lorg/kethereum/wallet/model/ScryptConfig;", "getLIGHT_SCRYPT_CONFIG", "()Lorg/kethereum/wallet/model/ScryptConfig;", "R", "STANDARD_SCRYPT_CONFIG", "getSTANDARD_SCRYPT_CONFIG", "UTF_8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "createWallet", "Lorg/kethereum/wallet/model/Wallet;", "ecKeyPair", "Lorg/kethereum/model/ECKeyPair;", "cipherText", "", "iv", "mac", "scryptKdfParams", "Lorg/kethereum/wallet/model/ScryptKdfParams;", "generateAes128CtrDerivedKey", "password", "kdfParams", "Lorg/kethereum/wallet/model/Aes128CtrKdfParams;", "generateDerivedScryptKey", "generateMac", "derivedKey", "generateRandomBytes", "size", "performCipherOperation", "operation", "Lorg/kethereum/crypto/api/cipher/AESCipher$Operation;", "encryptKey", "text", "config", "decrypt", "getCrypto", "Lorg/kethereum/wallet/model/WalletCrypto;", "Lorg/kethereum/wallet/model/WalletForImport;", "toTypedWallet", "validate", "", "wallet"})
public final class WalletKt {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int R = 8;
    private static final int DKLEN = 32;
    private static final int CURRENT_VERSION = 3;
    private static final String CIPHER = "aes-128-ctr";
    @NotNull
    private static final ScryptConfig LIGHT_SCRYPT_CONFIG = new ScryptConfig(4096, 6);
    @NotNull
    private static final ScryptConfig STANDARD_SCRYPT_CONFIG = new ScryptConfig(262144, 1);

    @NotNull
    public static final ScryptConfig getLIGHT_SCRYPT_CONFIG() {
        return LIGHT_SCRYPT_CONFIG;
    }

    @NotNull
    public static final ScryptConfig getSTANDARD_SCRYPT_CONFIG() {
        return STANDARD_SCRYPT_CONFIG;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Wallet createWallet(@NotNull ECKeyPair $this$createWallet, @NotNull String password, @NotNull ScryptConfig config) {
        byte[] derivedKey;
        void $this$apply22;
        Intrinsics.checkNotNullParameter((Object)$this$createWallet, (String)"$this$createWallet");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        byte[] mySalt = WalletKt.generateRandomBytes(32);
        Object object = password;
        Charset charset = UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        int n = 0;
        byte[] byArray = ((String)object).getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = null;
        int n2 = 0;
        n = config.getP();
        int n3 = 8;
        object = new ScryptKdfParams(config.getN(), n, n3, n2, (String)object, 24, null);
        n2 = 0;
        n = 0;
        Object object2 = object;
        byte[] byArray2 = byArray;
        boolean bl = false;
        $this$apply22.setDklen(32);
        $this$apply22.setSalt(ByteArrayExtensionsKt.toNoPrefixHexString((byte[])mySalt));
        Unit unit = Unit.INSTANCE;
        byte[] byArray3 = derivedKey = WalletKt.generateDerivedScryptKey(byArray2, (ScryptKdfParams)object);
        n = 0;
        int $this$apply22 = 16;
        bl = false;
        byte[] encryptKey = ArraysKt.copyOfRange((byte[])byArray3, (int)n, (int)$this$apply22);
        byte[] iv = WalletKt.generateRandomBytes(16);
        byte[] privateKeyBytes = BigIntegerKt.toBytesPadded((BigInteger)$this$createWallet.getPrivateKey-V6oYYD4(), (int)32);
        byte[] cipherText = WalletKt.performCipherOperation(AESCipher.Operation.ENCRYPTION, iv, encryptKey, privateKeyBytes);
        byte[] mac = WalletKt.generateMac(derivedKey, cipherText);
        return WalletKt.createWallet($this$createWallet, cipherText, iv, mac, new ScryptKdfParams(config.getN(), config.getP(), 8, 32, ByteArrayExtensionsKt.toNoPrefixHexString((byte[])mySalt)));
    }

    private static final Wallet createWallet(ECKeyPair ecKeyPair, byte[] cipherText, byte[] iv, byte[] mac, ScryptKdfParams scryptKdfParams) {
        String string = ConvertersKt.toAddress((ECKeyPair)ecKeyPair).getCleanHex();
        String string2 = ByteArrayExtensionsKt.toNoPrefixHexString((byte[])mac);
        CipherParams cipherParams = new CipherParams(ByteArrayExtensionsKt.toNoPrefixHexString((byte[])iv));
        KdfParams kdfParams = scryptKdfParams;
        String string3 = "scrypt";
        WalletCrypto walletCrypto = new WalletCrypto(CIPHER, ByteArrayExtensionsKt.toNoPrefixHexString((byte[])cipherText), cipherParams, string3, kdfParams, string2);
        String string4 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"UUID.randomUUID().toString()");
        return new Wallet(string, walletCrypto, string4, 3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final byte[] generateDerivedScryptKey(byte[] password, ScryptKdfParams kdfParams) {
        byte[] byArray;
        SCrypt sCrypt = CryptoAPI.INSTANCE.getScrypt();
        byte[] byArray2 = password;
        String string = kdfParams.getSalt();
        if (string != null) {
            void it;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            byte[] byArray3 = byArray2;
            SCrypt sCrypt2 = sCrypt;
            boolean bl3 = false;
            String string4 = HexString.constructor-impl((String)it);
            sCrypt = sCrypt2;
            byArray2 = byArray3;
            string = string4;
            if (string != null) {
                byArray = HexStringExtensionsKt.hexToByteArray-jorw2Fc((String)string);
                return sCrypt.derive(byArray2, byArray, kdfParams.getN(), kdfParams.getR(), kdfParams.getP(), kdfParams.getDklen());
            }
        }
        byArray = null;
        return sCrypt.derive(byArray2, byArray, kdfParams.getN(), kdfParams.getR(), kdfParams.getP(), kdfParams.getDklen());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final byte[] generateAes128CtrDerivedKey(byte[] password, Aes128CtrKdfParams kdfParams) throws CipherException {
        byte[] byArray;
        if (Intrinsics.areEqual((Object)kdfParams.getPrf(), (Object)"hmac-sha256") ^ true) {
            throw (Throwable)new CipherException("Unsupported prf:" + kdfParams.getPrf());
        }
        PBKDF2 pBKDF2 = CryptoAPI.INSTANCE.getPbkdf2();
        byte[] byArray2 = password;
        String string = kdfParams.getSalt();
        if (string != null) {
            void it;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            byte[] byArray3 = byArray2;
            PBKDF2 pBKDF22 = pBKDF2;
            boolean bl3 = false;
            String string4 = HexString.constructor-impl((String)it);
            pBKDF2 = pBKDF22;
            byArray2 = byArray3;
            string = string4;
            if (string != null) {
                byArray = HexStringExtensionsKt.hexToByteArray-jorw2Fc((String)string);
                return pBKDF2.derive(byArray2, byArray, kdfParams.getC(), (DigestParams)DigestParams.Sha256.INSTANCE);
            }
        }
        byArray = null;
        return pBKDF2.derive(byArray2, byArray, kdfParams.getC(), (DigestParams)DigestParams.Sha256.INSTANCE);
    }

    private static final byte[] performCipherOperation(AESCipher.Operation operation, byte[] iv, byte[] encryptKey, byte[] text) throws CipherException {
        byte[] byArray;
        try {
            byArray = CryptoAPI.INSTANCE.getAesCipher().init(AESCipher.Mode.CTR, AESCipher.Padding.NO, operation, encryptKey, iv).performOperation(text);
        }
        catch (Exception e) {
            throw (Throwable)new CipherException("Error performing cipher operation", e);
        }
        return byArray;
    }

    private static final byte[] generateMac(byte[] derivedKey, byte[] cipherText) {
        byte[] result = new byte[16 + cipherText.length];
        System.arraycopy(derivedKey, 16, result, 0, 16);
        System.arraycopy(cipherText, 0, result, 16, cipherText.length);
        return KeccakKt.keccak((byte[])result);
    }

    @NotNull
    public static final ECKeyPair decrypt(@NotNull Wallet $this$decrypt, @NotNull String password) throws CipherException {
        byte[] byArray;
        int n;
        Charset charset;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$decrypt, (String)"$this$decrypt");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        WalletKt.validate($this$decrypt);
        byte[] mac = HexStringExtensionsKt.hexToByteArray-jorw2Fc((String)HexString.constructor-impl((String)$this$decrypt.getCrypto().getMac()));
        byte[] iv = HexStringExtensionsKt.hexToByteArray-jorw2Fc((String)HexString.constructor-impl((String)$this$decrypt.getCrypto().getCipherparams().getIv()));
        byte[] cipherText = HexStringExtensionsKt.hexToByteArray-jorw2Fc((String)HexString.constructor-impl((String)$this$decrypt.getCrypto().getCiphertext()));
        KdfParams kdfParams = $this$decrypt.getCrypto().getKdfparams();
        if (kdfParams instanceof ScryptKdfParams) {
            object = password;
            Charset charset2 = UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
            n = 0;
            byte[] byArray2 = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byArray = WalletKt.generateDerivedScryptKey(byArray2, (ScryptKdfParams)kdfParams);
        } else if (kdfParams instanceof Aes128CtrKdfParams) {
            object = password;
            Charset charset3 = UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"UTF_8");
            charset = charset3;
            n = 0;
            byte[] byArray3 = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
            byArray = WalletKt.generateAes128CtrDerivedKey(byArray3, (Aes128CtrKdfParams)kdfParams);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        byte[] derivedKey = byArray;
        byte[] derivedMac = WalletKt.generateMac(derivedKey, cipherText);
        object = derivedMac;
        boolean bl = false;
        if (!Arrays.equals((byte[])object, mac)) {
            throw (Throwable)new InvalidPasswordException();
        }
        byte[] byArray4 = derivedKey;
        n = 0;
        int n2 = 16;
        boolean bl2 = false;
        byte[] encryptKey = ArraysKt.copyOfRange((byte[])byArray4, (int)n, (int)n2);
        BigInteger privateKey = PrivateKey.constructor-impl((byte[])WalletKt.performCipherOperation(AESCipher.Operation.DESCRYPTION, iv, encryptKey, cipherText));
        return ConvertersKt.toECKeyPair-UWICACY((BigInteger)privateKey);
    }

    public static final void validate(@NotNull Wallet $this$validate) throws CipherException {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"$this$validate");
        if ($this$validate.getVersion() != 3) {
            throw (Throwable)new CipherException("Wallet version is not supported");
        }
        if (Intrinsics.areEqual((Object)$this$validate.getCrypto().getCipher(), (Object)CIPHER) ^ true) {
            throw (Throwable)new CipherException("Wallet cipher is not supported");
        }
        if (Intrinsics.areEqual((Object)$this$validate.getCrypto().getKdf(), (Object)"pbkdf2") ^ true && Intrinsics.areEqual((Object)$this$validate.getCrypto().getKdf(), (Object)"scrypt") ^ true) {
            throw (Throwable)new CipherException("KDF type is not supported");
        }
        if (Intrinsics.areEqual((Object)$this$validate.getCrypto().getKdf(), (Object)"pbkdf2") && !($this$validate.getCrypto().getKdfparams() instanceof Aes128CtrKdfParams) || Intrinsics.areEqual((Object)$this$validate.getCrypto().getKdf(), (Object)"scrypt") && !($this$validate.getCrypto().getKdfparams() instanceof ScryptKdfParams)) {
            throw (Throwable)new CipherException("KDFParams invalid");
        }
    }

    @NotNull
    public static final byte[] generateRandomBytes(int size) {
        byte[] byArray = new byte[size];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        SecureRandomUtils.INSTANCE.secureRandom().nextBytes($this$apply);
        return byArray;
    }

    @Nullable
    public static final WalletCrypto getCrypto(@NotNull WalletForImport $this$getCrypto) {
        Intrinsics.checkNotNullParameter((Object)$this$getCrypto, (String)"$this$getCrypto");
        WalletCrypto walletCrypto = $this$getCrypto.getCrypto();
        if (walletCrypto == null) {
            walletCrypto = $this$getCrypto.getCryptoFromMEW();
        }
        return walletCrypto;
    }

    @NotNull
    public static final Wallet toTypedWallet(@NotNull WalletForImport $this$toTypedWallet) {
        Intrinsics.checkNotNullParameter((Object)$this$toTypedWallet, (String)"$this$toTypedWallet");
        String string = $this$toTypedWallet.getAddress();
        WalletCrypto walletCrypto = WalletKt.getCrypto($this$toTypedWallet);
        Intrinsics.checkNotNull((Object)walletCrypto);
        String string2 = $this$toTypedWallet.getId();
        Intrinsics.checkNotNull((Object)string2);
        return new Wallet(string, walletCrypto, string2, $this$toTypedWallet.getVersion());
    }
}

