/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.keystore.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kethereum.keystore.api.KeyStore;
import org.kethereum.model.Address;
import org.kethereum.model.ECKeyPair;
import org.kethereum.wallet.WalletFileKt;
import org.kethereum.wallet.WalletKt;
import org.kethereum.wallet.model.ScryptConfig;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/kethereum/keystore/api/FileKeyStore;", "Lorg/kethereum/keystore/api/KeyStore;", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "fileMap", "", "Lorg/kethereum/model/Address;", "getFileMap", "()Ljava/util/Map;", "fileMap$delegate", "Lkotlin/Lazy;", "addKey", "key", "Lorg/kethereum/model/ECKeyPair;", "password", "", "light", "", "scryptConfig", "Lorg/kethereum/wallet/model/ScryptConfig;", "deleteKey", "address", "getAddresses", "", "getKeyForAddress", "hasKeyForForAddress", "rebuildList", "", "keystore"})
public class FileKeyStore
implements KeyStore {
    private final Lazy fileMap$delegate;
    private final File dir;

    private final Map<Address, File> getFileMap() {
        Lazy lazy = this.fileMap$delegate;
        FileKeyStore fileKeyStore = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void rebuildList(Map<Address, File> $this$rebuildList) {
        File[] fileArray = this.dir.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var7_8 = $this$filterTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var7_8[i];
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                if (!(!v1.isDirectory())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                $this$rebuildList.put(new Address(StringsKt.removeSuffix((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])new String[]{"--"}, (boolean)false, (int)0, (int)6, null))), (CharSequence)".json")), it);
            }
        }
    }

    @Override
    @NotNull
    public Set<Address> getAddresses() {
        return this.getFileMap().keySet();
    }

    @Override
    public boolean hasKeyForForAddress(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.getFileMap().containsKey(address);
    }

    @Override
    @Nullable
    public ECKeyPair getKeyForAddress(@NotNull Address address, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        File file = this.getFileMap().get(address);
        return file != null ? WalletFileKt.loadKeysFromWalletFile((File)file, (String)password) : null;
    }

    @Override
    public boolean deleteKey(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        File file = this.getFileMap().get(address);
        boolean bl = file != null ? file.delete() : false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean it = bl;
        boolean bl4 = false;
        this.getFileMap().remove(address);
        return bl;
    }

    private final Address addKey(ECKeyPair key, String password, ScryptConfig scryptConfig) {
        Address address;
        String string = WalletFileKt.generateWalletFile((ECKeyPair)key, (String)password, (File)this.dir, (ScryptConfig)scryptConfig).getWallet().getAddress();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.rebuildList(this.getFileMap());
            address = new Address(it);
        } else {
            address = null;
        }
        return address;
    }

    @Override
    @Nullable
    public Address addKey(@NotNull ECKeyPair key, @NotNull String password, boolean light) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.addKey(key, password, light ? WalletKt.getLIGHT_SCRYPT_CONFIG() : WalletKt.getSTANDARD_SCRYPT_CONFIG());
    }

    public FileKeyStore(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        this.fileMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<Address, File>>(this){
            final /* synthetic */ FileKeyStore this$0;

            @NotNull
            public final Map<Address, File> invoke() {
                boolean bl = false;
                Map map = new LinkedHashMap<K, V>();
                boolean bl2 = false;
                boolean bl3 = false;
                Map $this$apply = map;
                boolean bl4 = false;
                FileKeyStore.access$rebuildList(this.this$0, $this$apply);
                return map;
            }
            {
                this.this$0 = fileKeyStore;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ void access$rebuildList(FileKeyStore $this, Map $this$access_u24rebuildList) {
        $this.rebuildList($this$access_u24rebuildList);
    }
}

