package org.komputing.kethereum.erc634

import kotlin.Boolean
import kotlin.ByteArray
import kotlin.String
import org.kethereum.contract.abi.types.PaginatedByteArray
import org.kethereum.contract.abi.types.encodeTypes
import org.kethereum.contract.abi.types.model.type_params.BitsTypeParams
import org.kethereum.contract.abi.types.model.type_params.BytesTypeParams
import org.kethereum.contract.abi.types.model.types.BytesETHType
import org.kethereum.contract.abi.types.model.types.StringETHType
import org.kethereum.model.Address
import org.kethereum.model.Transaction
import org.kethereum.model.createEmptyTransaction
import org.kethereum.rpc.EthereumRPC

val FourByteText: ByteArray = byteArrayOf(89, -47, -44, 60)

class ERC634TransactionGenerator(
  address: Address
) {
  private val tx: Transaction = createEmptyTransaction().apply { to = address }

  internal fun textETHTyped(node: BytesETHType, key: StringETHType) = tx.copy(input = FourByteText +
      encodeTypes(node, key))
  /**
   * Signature: text(bytes32,string)
   * 4Byte: 59d1d43c
   */
  fun text(node: ByteArray, key: String): Transaction =
      textETHTyped(BytesETHType.ofNativeKotlinType(node,BytesTypeParams(bytes=32)),
      StringETHType.ofNativeKotlinType(key))
}

class ERC634RPCConnector(
  private val address: Address,
  private val rpc: EthereumRPC
) {
  private val txGenerator: ERC634TransactionGenerator = ERC634TransactionGenerator(address)

  private fun textETHTyped(
    node: BytesETHType,
    key: StringETHType,
    blockSpec: String = "latest"
  ): StringETHType? {
    val tx = txGenerator.textETHTyped(node, key)
    return StringETHType.ofPaginatedByteArray(PaginatedByteArray(rpc.call(tx, blockSpec)))
  }

  /**
   * Signature: text(bytes32,string)
   * 4Byte: 59d1d43c
   */
  fun text(
    node: ByteArray,
    key: String,
    blockSpec: String = "latest"
  ): String? = textETHTyped(BytesETHType.ofNativeKotlinType(node,BytesTypeParams(bytes=32)),
      StringETHType.ofNativeKotlinType(key),blockSpec)?.toKotlinType()
}

class ERC634TransactionDecoder {
  fun isText(tx: Transaction): Boolean = tx.input.sliceArray(0..3).contentEquals(FourByteText)
}
