package org.kethereum.ens.generated

import kotlin.Boolean
import kotlin.ByteArray
import kotlin.String
import org.kethereum.contract.abi.types.PaginatedByteArray
import org.kethereum.contract.abi.types.encodeTypes
import org.kethereum.contract.abi.types.model.type_params.BitsTypeParams
import org.kethereum.contract.abi.types.model.type_params.BytesTypeParams
import org.kethereum.contract.abi.types.model.types.BytesETHType
import org.kethereum.contract.abi.types.model.types.DynamicSizedBytesETHType
import org.kethereum.model.Address
import org.kethereum.model.Transaction
import org.kethereum.model.createEmptyTransaction
import org.kethereum.rpc.EthereumRPC

val FourByteSetContenthash: ByteArray = byteArrayOf(48, 78, 106, -34)

val FourByteContenthash: ByteArray = byteArrayOf(-68, 28, 88, -47)

class ContentHashResolverTransactionGenerator(
  address: Address
) {
  private val tx: Transaction = createEmptyTransaction().apply { to = address }

  internal fun setContenthashETHTyped(node: BytesETHType, hash: DynamicSizedBytesETHType) =
      tx.copy(input = FourByteSetContenthash + encodeTypes(node, hash))
  /**
   * Signature: setContenthash(bytes32,bytes)
   * 4Byte: 304e6ade
   */
  fun setContenthash(node: ByteArray, hash: ByteArray): Transaction =
      setContenthashETHTyped(BytesETHType.ofNativeKotlinType(node,BytesTypeParams(bytes=32)),
      DynamicSizedBytesETHType.ofNativeKotlinType(hash))

  internal fun contenthashETHTyped(node: BytesETHType) = tx.copy(input = FourByteContenthash +
      encodeTypes(node))
  /**
   * Signature: contenthash(bytes32)
   * 4Byte: bc1c58d1
   */
  fun contenthash(node: ByteArray): Transaction =
      contenthashETHTyped(BytesETHType.ofNativeKotlinType(node,BytesTypeParams(bytes=32)))
}

class ContentHashResolverRPCConnector(
  private val address: Address,
  private val rpc: EthereumRPC
) {
  private val txGenerator: ContentHashResolverTransactionGenerator =
      ContentHashResolverTransactionGenerator(address)

  private fun setContenthashETHTyped(
    node: BytesETHType,
    hash: DynamicSizedBytesETHType,
    blockSpec: String = "latest"
  ) {
    val tx = txGenerator.setContenthashETHTyped(node, hash)
    rpc.call(tx, blockSpec)
  }

  /**
   * Signature: setContenthash(bytes32,bytes)
   * 4Byte: 304e6ade
   */
  fun setContenthash(
    node: ByteArray,
    hash: ByteArray,
    blockSpec: String = "latest"
  ) {
    setContenthashETHTyped(BytesETHType.ofNativeKotlinType(node,BytesTypeParams(bytes=32)),
        DynamicSizedBytesETHType.ofNativeKotlinType(hash),blockSpec)
  }

  private fun contenthashETHTyped(node: BytesETHType, blockSpec: String = "latest"):
      DynamicSizedBytesETHType? {
    val tx = txGenerator.contenthashETHTyped(node)
    return DynamicSizedBytesETHType.ofPaginatedByteArray(PaginatedByteArray(rpc.call(tx,
        blockSpec)))
  }

  /**
   * Signature: contenthash(bytes32)
   * 4Byte: bc1c58d1
   */
  fun contenthash(node: ByteArray, blockSpec: String = "latest"): ByteArray? =
      contenthashETHTyped(BytesETHType.ofNativeKotlinType(node,BytesTypeParams(bytes=32)),blockSpec)?.toKotlinType()
}

class ContentHashResolverTransactionDecoder {
  fun isSetContenthash(tx: Transaction): Boolean =
      tx.input.sliceArray(0..3).contentEquals(FourByteSetContenthash)

  fun isContenthash(tx: Transaction): Boolean =
      tx.input.sliceArray(0..3).contentEquals(FourByteContenthash)
}
