/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.erc1577;

import io.ipfs.multiformats.multihash.Multihash;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.kethereum.erc1577.model.ContentTooShort;
import org.kethereum.erc1577.model.ContentTypeError;
import org.kethereum.erc1577.model.HashLengthError;
import org.kethereum.erc1577.model.InvalidCIDError;
import org.kethereum.erc1577.model.InvalidStorageSystem;
import org.kethereum.erc1577.model.SuccessfulToURIResult;
import org.kethereum.erc1577.model.ToURIResult;
import org.komputing.kbase58.Base58Kt;
import org.komputing.khex.extensions.ByteArrayExtensionsKt;
import org.komputing.kvarint.ReadVarUIntKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"encodeToMultiHashString", "", "content", "", "hashFunction", "Lkotlin/UInt;", "encodeToMultiHashString-aLocdiE", "([BI)Ljava/lang/String;", "toURI", "Lorg/kethereum/erc1577/model/ToURIResult;", "Lorg/kethereum/erc1577/model/ContentHash;", "toURI-ancGgq8", "([B)Lorg/kethereum/erc1577/model/ToURIResult;", "erc1577"})
public final class ContentHashToURIKt {
    @NotNull
    public static final ToURIResult toURI-ancGgq8(@NotNull byte[] $this$toURI) {
        ToURIResult toURIResult;
        Intrinsics.checkNotNullParameter((Object)$this$toURI, (String)"$this$toURI");
        if ($this$toURI.length < 6) {
            return new ContentTooShort(null, 1, null);
        }
        byte[] byArray = $this$toURI;
        boolean bl = false;
        BufferedSource buffer = Okio.buffer((Source)Okio.source((InputStream)new ByteArrayInputStream(byArray)));
        int storageByte = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
        int cid = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
        if (cid != 1) {
            return new InvalidCIDError(cid, null);
        }
        switch (storageByte) {
            case 227: {
                int contentType = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                int hashFunction = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                int n = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                boolean bl2 = false;
                int hashLength = n;
                byte[] content = buffer.readByteArray();
                if (hashLength != content.length) {
                    toURIResult = new HashLengthError(hashLength, content.length);
                    break;
                }
                if (contentType != 112) {
                    toURIResult = new ContentTypeError(contentType, 112, null);
                    break;
                }
                toURIResult = new SuccessfulToURIResult("ipfs://" + ContentHashToURIKt.encodeToMultiHashString-aLocdiE(content, hashFunction));
                break;
            }
            case 228: {
                int contentType = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                int hashFunction = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                int content = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                boolean bl3 = false;
                int hashLength = content;
                byte[] content2 = buffer.readByteArray();
                if (contentType != 250) {
                    toURIResult = new ContentTypeError(contentType, 250, null);
                    break;
                }
                if (hashLength != content2.length) {
                    toURIResult = new HashLengthError(hashLength, content2.length);
                    break;
                }
                toURIResult = new SuccessfulToURIResult("bzz://" + ByteArrayExtensionsKt.toNoPrefixHexString((byte[])content2));
                break;
            }
            case 229: {
                int contentType = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                int hashFunction = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                int content2 = ReadVarUIntKt.readVarUInt((BufferedSource)buffer);
                boolean bl4 = false;
                int hashLength = content2;
                byte[] content3 = buffer.readByteArray();
                if (hashLength != content3.length) {
                    toURIResult = new HashLengthError(hashLength, content3.length);
                    break;
                }
                if (contentType != 112) {
                    toURIResult = new ContentTypeError(contentType, 112, null);
                    break;
                }
                toURIResult = new SuccessfulToURIResult("ipns://" + ContentHashToURIKt.encodeToMultiHashString-aLocdiE(content3, hashFunction));
                break;
            }
            default: {
                toURIResult = new InvalidStorageSystem(storageByte, null);
            }
        }
        return toURIResult;
    }

    private static final String encodeToMultiHashString-aLocdiE(byte[] content, int hashFunction) {
        String string;
        if (hashFunction == 0) {
            boolean bl = false;
            string = new String(content, Charsets.UTF_8);
        } else {
            string = Base58Kt.encodeToBase58String((byte[])Multihash.Companion.encode-aLocdiE(content, hashFunction));
        }
        return string;
    }
}

