/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.crypto;

import java.math.BigInteger;
import java.security.SignatureException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kethereum.crypto.CryptoAPI;
import org.kethereum.crypto.api.ec.Curve;
import org.kethereum.crypto.api.ec.ECDSASignature;
import org.kethereum.crypto.api.ec.Signer;
import org.kethereum.keccakshortcut.KeccakKt;
import org.kethereum.model.ECKeyPair;
import org.kethereum.model.PublicKey;
import org.kethereum.model.SignatureData;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\u001a\u001b\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\b\u0010\t\u001a-\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u000f\u001a\u001e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0013\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a'\u0010\u001c\u001a\u00020\u001d*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0012\u0010!\u001a\u00020\u0013*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\r\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"CURVE", "Lorg/kethereum/crypto/api/ec/Curve;", "getCURVE", "()Lorg/kethereum/crypto/api/ec/Curve;", "publicKeyFromPrivate", "Lorg/kethereum/model/PublicKey;", "privateKey", "Lorg/kethereum/model/PrivateKey;", "publicKeyFromPrivate-UWICACY", "(Ljava/math/BigInteger;)Ljava/math/BigInteger;", "sign", "Lorg/kethereum/crypto/api/ec/ECDSASignature;", "transactionHash", "", "canonical", "", "sign-NsvMPqk", "([BLjava/math/BigInteger;Z)Lorg/kethereum/crypto/api/ec/ECDSASignature;", "signMessageHash", "Lorg/kethereum/model/SignatureData;", "messageHash", "keyPair", "Lorg/kethereum/model/ECKeyPair;", "toCanonical", "signedMessageToKey", "message", "signatureData", "([BLorg/kethereum/model/SignatureData;)Ljava/math/BigInteger;", "determineRecId", "", "publicKey", "determineRecId-GmnVG7U", "(Lorg/kethereum/crypto/api/ec/ECDSASignature;[BLjava/math/BigInteger;)I", "signMessage", "crypto"})
public final class SignKt {
    @NotNull
    private static final Curve CURVE = CryptoAPI.INSTANCE.getCurve();

    @NotNull
    public static final Curve getCURVE() {
        return CURVE;
    }

    @NotNull
    public static final SignatureData signMessage(@NotNull ECKeyPair $this$signMessage, @NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)$this$signMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return SignKt.signMessageHash(KeccakKt.keccak((byte[])message), $this$signMessage, true);
    }

    @NotNull
    public static final SignatureData signMessageHash(@NotNull byte[] messageHash, @NotNull ECKeyPair keyPair, boolean toCanonical) {
        Intrinsics.checkNotNullParameter((Object)messageHash, (String)"messageHash");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        BigInteger privateKey = keyPair.getPrivateKey-V6oYYD4();
        BigInteger publicKey = keyPair.getPublicKey-ERNsaTg();
        ECDSASignature signature = SignKt.sign-NsvMPqk(messageHash, privateKey, toCanonical);
        int recId = SignKt.determineRecId-GmnVG7U(signature, messageHash, publicKey);
        int headerByte = recId + 27;
        BigInteger bigInteger = signature.getR();
        BigInteger bigInteger2 = signature.getS();
        BigInteger bigInteger3 = BigInteger.valueOf(headerByte);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(this.toLong())");
        return new SignatureData(bigInteger, bigInteger2, bigInteger3);
    }

    public static /* synthetic */ SignatureData signMessageHash$default(byte[] byArray, ECKeyPair eCKeyPair, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return SignKt.signMessageHash(byArray, eCKeyPair, bl);
    }

    public static final int determineRecId-GmnVG7U(@NotNull ECDSASignature $this$determineRecId, @NotNull byte[] messageHash, @NotNull BigInteger publicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$determineRecId, (String)"$this$determineRecId");
        Intrinsics.checkNotNullParameter((Object)messageHash, (String)"messageHash");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Signer signer = CryptoAPI.INSTANCE.getSigner();
        int n = 0;
        while (n < 4) {
            int i;
            BigInteger k;
            if ((k = signer.recover(i = n++, $this$determineRecId, messageHash)) == null || !Intrinsics.areEqual((Object)k, (Object)publicKey)) continue;
            return i;
        }
        throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
    }

    private static final ECDSASignature sign-NsvMPqk(byte[] transactionHash, BigInteger privateKey, boolean canonical) {
        return CryptoAPI.INSTANCE.getSigner().sign(transactionHash, privateKey, canonical);
    }

    @NotNull
    public static final BigInteger signedMessageToKey(@NotNull byte[] message, @NotNull SignatureData signatureData) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)signatureData, (String)"signatureData");
        byte[] byArray = signatureData.getV().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"signatureData.v.toByteArray()");
        byte header = ArraysKt.last((byte[])byArray);
        if (header < 27 || header > 34) {
            throw new SignatureException(Intrinsics.stringPlus((String)"Header byte out of range: ", (Object)header));
        }
        ECDSASignature sig = new ECDSASignature(signatureData.getR(), signatureData.getS());
        byte[] messageHash = KeccakKt.keccak((byte[])message);
        int recId = header - 27;
        BigInteger bigInteger = CryptoAPI.INSTANCE.getSigner().recover(recId, sig, messageHash);
        if (bigInteger == null) {
            throw new SignatureException("Could not recover public key from signature");
        }
        return PublicKey.constructor-impl((BigInteger)bigInteger);
    }

    @NotNull
    public static final BigInteger publicKeyFromPrivate-UWICACY(@NotNull BigInteger privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return PublicKey.constructor-impl((BigInteger)CryptoAPI.INSTANCE.getSigner().publicFromPrivate(privateKey));
    }
}

