/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.crypto;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kethereum.crypto.CryptoAPI;
import org.kethereum.crypto.SignKt;
import org.kethereum.crypto.api.ec.CurvePoint;
import org.kethereum.extensions.BigIntegerKt;
import org.kethereum.model.ECKeyPair;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0003*\u00020\u0001\u00a8\u0006\u0006"}, d2={"createEthereumKeyPair", "Lorg/kethereum/model/ECKeyPair;", "decompressKey", "", "publicBytes", "getCompressedPublicKey", "crypto"})
public final class KeysKt {
    @NotNull
    public static final ECKeyPair createEthereumKeyPair() {
        return CryptoAPI.INSTANCE.getKeyPairGenerator().generate();
    }

    @NotNull
    public static final byte[] getCompressedPublicKey(@NotNull ECKeyPair $this$getCompressedPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$getCompressedPublicKey, (String)"<this>");
        byte[] ret = BigIntegerKt.toBytesPadded((BigInteger)$this$getCompressedPublicKey.getPublicKey-ERNsaTg(), (int)65);
        ret[0] = 4;
        CurvePoint point = SignKt.getCURVE().decodePoint(ret);
        return point.encoded(true);
    }

    @NotNull
    public static final byte[] decompressKey(@NotNull byte[] publicBytes) {
        byte[] encoded;
        Intrinsics.checkNotNullParameter((Object)publicBytes, (String)"publicBytes");
        CurvePoint point = SignKt.getCURVE().decodePoint(publicBytes);
        byte[] byArray = encoded = CurvePoint.DefaultImpls.encoded$default((CurvePoint)point, (boolean)false, (int)1, null);
        int n = 1;
        int n2 = encoded.length;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }
}

