/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.crypto;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0014J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kethereum/crypto/LinuxSecureRandom;", "Ljava/security/SecureRandomSpi;", "()V", "dis", "Ljava/io/DataInputStream;", "engineGenerateSeed", "", "i", "", "engineNextBytes", "", "bytes", "engineSetSeed", "Companion", "LinuxSecureRandomProvider", "crypto"})
public final class LinuxSecureRandom
extends SecureRandomSpi {
    private final DataInputStream dis = new DataInputStream(urandom);
    private static final FileInputStream urandom;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    protected void engineSetSeed(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
    }

    @Override
    protected void engineNextBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            this.dis.readFully(bytes);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    protected byte[] engineGenerateSeed(int i) {
        byte[] byArray = new byte[i];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        this.engineNextBytes($this$apply);
        return byArray;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(LinuxSecureRandom.class);
        try {
            File file = new File("/dev/urandom");
            urandom = new FileInputStream(file);
            if (urandom.read() == -1) {
                throw (Throwable)new RuntimeException("/dev/urandom not readable?");
            }
            int position = Security.insertProviderAt(new LinuxSecureRandomProvider(), 1);
            if (position != -1) {
                log.info("Secure randomness will be read from {} only.", (Object)file);
            } else {
                log.info("Randomness is already secure.");
            }
        }
        catch (FileNotFoundException e) {
            log.error("/dev/urandom does not appear to exist or is not openable");
            throw (Throwable)new RuntimeException(e);
        }
        catch (IOException e) {
            log.error("/dev/urandom does not appear to be readable");
            throw (Throwable)new RuntimeException(e);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/kethereum/crypto/LinuxSecureRandom$LinuxSecureRandomProvider;", "Ljava/security/Provider;", "()V", "crypto"})
    private static final class LinuxSecureRandomProvider
    extends Provider {
        public LinuxSecureRandomProvider() {
            super("LinuxSecureRandom", 1.0, "A Linux specific random number provider that uses /dev/urandom");
            this.put("SecureRandom.LinuxSecureRandom", LinuxSecureRandom.class.getName());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kethereum/crypto/LinuxSecureRandom$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "urandom", "Ljava/io/FileInputStream;", "crypto"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

