/*
 * Decompiled with CFR 0.152.
 */
package com.kodgemisi.specification;

import com.kodgemisi.specification.ComparableFilterCriteria;
import com.kodgemisi.specification.ConditionType;
import com.kodgemisi.specification.CriteriaOperation;
import com.kodgemisi.specification.FilterCriteria;
import com.kodgemisi.specification.GenericSpecification;
import com.kodgemisi.specification.GenericSpecificationContainer;
import com.kodgemisi.specification.RelationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import org.springframework.data.jpa.domain.Specification;

public class GenericSpecificationBuilder<E> {
    private final List<FilterCriteria<?>> filterCriteriaList = new ArrayList();
    private final List<Specification<E>> specifications = new ArrayList<Specification<E>>();
    private final Map<Specification<E>, ConditionType> customSpecifications;
    private final List<Map<String, String>> parameters = new ArrayList<Map<String, String>>();
    private ConditionType activeConditionType = ConditionType.AND;

    private GenericSpecificationBuilder() {
        this.customSpecifications = new HashMap<Specification<E>, ConditionType>();
    }

    public static <E> GenericSpecificationBuilder<E> of(Class<E> clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Only entities allowed.");
        }
        return new GenericSpecificationBuilder<E>();
    }

    private GenericSpecificationBuilder<E> addCriteria(String key, CriteriaOperation operation) {
        this.filterCriteriaList.add(new FilterCriteria<Void>(key, operation, null, Void.class, this.activeConditionType));
        return this;
    }

    private GenericSpecificationBuilder<E> addCriteria(String key, CriteriaOperation operation, JoinType joinType) {
        this.filterCriteriaList.add(new FilterCriteria<Void>(key, operation, joinType, Void.class, this.activeConditionType));
        return this;
    }

    private <C> GenericSpecificationBuilder<E> addCriteria(String key, C value, CriteriaOperation operation, RelationType relationType) {
        if (value != null) {
            this.filterCriteriaList.add(new FilterCriteria<C>(key, value, operation, value.getClass(), relationType, this.activeConditionType));
        }
        return this;
    }

    private <C extends Comparable<? super C>> GenericSpecificationBuilder<E> addComparableCriteria(String key, C value, CriteriaOperation operation, RelationType relationType) {
        if (value != null) {
            this.filterCriteriaList.add(new ComparableFilterCriteria<C>(key, value, operation, value.getClass(), relationType, this.activeConditionType));
        }
        return this;
    }

    public GenericSpecificationBuilder<E> or() {
        this.activeConditionType = ConditionType.OR;
        return this;
    }

    public GenericSpecificationBuilder<E> and() {
        this.activeConditionType = ConditionType.AND;
        return this;
    }

    public GenericSpecificationBuilder<E> join(String key) {
        return this.addCriteria(key, CriteriaOperation.JOIN, JoinType.INNER);
    }

    public GenericSpecificationBuilder<E> join(String key, JoinType joinType) {
        return this.addCriteria(key, CriteriaOperation.JOIN, joinType);
    }

    public GenericSpecificationBuilder<E> joinFetch(String key) {
        return this.addCriteria(key, CriteriaOperation.JOIN_FETCH, JoinType.INNER);
    }

    public GenericSpecificationBuilder<E> joinFetch(String key, JoinType joinType) {
        return this.addCriteria(key, CriteriaOperation.JOIN_FETCH, joinType);
    }

    public GenericSpecificationBuilder<E> equals(String key, Object value) {
        return this.addCriteria(key, value, CriteriaOperation.EQUAL, RelationType.NO_RELATION);
    }

    public GenericSpecificationBuilder<E> equals(String key, Object value, RelationType relationType) {
        return this.addCriteria(key, value, CriteriaOperation.EQUAL, relationType);
    }

    public GenericSpecificationBuilder<E> like(String key, Object value) {
        return this.addCriteria(key, value, CriteriaOperation.LIKE, RelationType.NO_RELATION);
    }

    public GenericSpecificationBuilder<E> like(String key, Object value, RelationType relationType) {
        return this.addCriteria(key, value, CriteriaOperation.LIKE, relationType);
    }

    public GenericSpecificationBuilder<E> isNull(String key) {
        return this.addCriteria(key, CriteriaOperation.IS_NULL);
    }

    public GenericSpecificationBuilder<E> isNotNull(String key) {
        return this.addCriteria(key, CriteriaOperation.IS_NOT_NULL);
    }

    public GenericSpecificationBuilder<E> in(String key, Object value) {
        return this.addCriteria(key, value, CriteriaOperation.IN, RelationType.NO_RELATION);
    }

    public GenericSpecificationBuilder<E> in(String key, Object value, RelationType relationType) {
        return this.addCriteria(key, value, CriteriaOperation.IN, relationType);
    }

    public <C extends Comparable<? super C>> GenericSpecificationBuilder<E> lessThan(String key, C value) {
        return this.addComparableCriteria(key, value, CriteriaOperation.LESS_THAN, RelationType.NO_RELATION);
    }

    public <C extends Comparable<? super C>> GenericSpecificationBuilder<E> lessThan(String key, C value, RelationType relationType) {
        return this.addComparableCriteria(key, value, CriteriaOperation.LESS_THAN, relationType);
    }

    public <C extends Comparable<? super C>> GenericSpecificationBuilder<E> lessThanOrEqualTo(String key, C value) {
        return this.addComparableCriteria(key, value, CriteriaOperation.LESS_THAN_OR_EQUAL_TO, RelationType.NO_RELATION);
    }

    public <C extends Comparable<? super C>> GenericSpecificationBuilder<E> lessThanOrEqualTo(String key, C value, RelationType relationType) {
        return this.addComparableCriteria(key, value, CriteriaOperation.LESS_THAN_OR_EQUAL_TO, relationType);
    }

    public <C extends Comparable<? super C>> GenericSpecificationBuilder<E> greaterThan(String key, C value) {
        return this.addComparableCriteria(key, value, CriteriaOperation.GREATER_THAN, RelationType.NO_RELATION);
    }

    public <C extends Comparable<? super C>> GenericSpecificationBuilder<E> greaterThan(String key, C value, RelationType relationType) {
        return this.addComparableCriteria(key, value, CriteriaOperation.GREATER_THAN, relationType);
    }

    public <C extends Comparable<? super C>> GenericSpecificationBuilder<E> greaterThanOrEqualTo(String key, C value) {
        return this.addComparableCriteria(key, value, CriteriaOperation.GREATER_THAN_OR_EQUAL_TO, RelationType.NO_RELATION);
    }

    public <C extends Comparable<? super C>> GenericSpecificationBuilder<E> greaterThanOrEqualTo(String key, C value, RelationType relationType) {
        return this.addComparableCriteria(key, value, CriteriaOperation.GREATER_THAN_OR_EQUAL_TO, relationType);
    }

    public GenericSpecificationBuilder<E> custom(Specification<E> specification) {
        this.customSpecifications.put(specification, this.activeConditionType);
        return this;
    }

    public GenericSpecificationBuilder<E> customFunction(String functionName, String[] fieldNames, String ... params) {
        int functionIndex = this.parameters.size();
        HashMap parameterMap = new HashMap();
        this.parameters.add(parameterMap);
        ArrayList<Specification & Serializable> specifications = new ArrayList<Specification & Serializable>();
        for (String fieldName : fieldNames) {
            Specification & Serializable fieldSpecification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
                int parameterIndex = 0;
                ArrayList<Object> parameterExpressions = new ArrayList<Object>();
                if (fieldName.contains(".")) {
                    String[] columns = fieldName.split("\\.");
                    Join joinedTable = root.join(columns[0], JoinType.LEFT);
                    Path path = joinedTable.get(columns[1]);
                    for (int i = 2; i < columns.length; ++i) {
                        path = path.get(columns[i]);
                    }
                    parameterExpressions.add(path);
                } else {
                    parameterExpressions.add(root.get(fieldName));
                }
                for (String param : params) {
                    String paramsName = "function" + functionIndex + "_param" + parameterIndex + "_" + System.currentTimeMillis();
                    parameterMap.put(paramsName, param);
                    ParameterExpression parameterExpression = criteriaBuilder.parameter(String.class, paramsName);
                    ++parameterIndex;
                    parameterExpressions.add(parameterExpression);
                }
                Expression[] parameters = parameterExpressions.toArray(new Expression[0]);
                Expression sqlFunction = criteriaBuilder.function(functionName, Boolean.class, parameters);
                return criteriaBuilder.equal(sqlFunction, (Object)"");
            };
            specifications.add(fieldSpecification);
        }
        Specification specificationResult = (Specification)specifications.get(0);
        for (int i = 1; i < specifications.size(); ++i) {
            specificationResult = Specification.where((Specification)specificationResult).or((Specification)specifications.get(i));
        }
        this.custom(specificationResult);
        return this;
    }

    public Specification<E> build() {
        if (this.filterCriteriaList.size() == 0) {
            return null;
        }
        Specification andSpecs = null;
        Specification orSpecs = null;
        for (FilterCriteria<?> filterCriteria : this.filterCriteriaList) {
            GenericSpecification specification = new GenericSpecification(filterCriteria);
            if (filterCriteria.getConditionType().equals((Object)ConditionType.AND)) {
                andSpecs = Specification.where(andSpecs).and(specification);
                continue;
            }
            orSpecs = Specification.where(orSpecs).or(specification);
        }
        for (Map.Entry entry : this.customSpecifications.entrySet()) {
            if (((ConditionType)((Object)entry.getValue())).equals((Object)ConditionType.AND)) {
                andSpecs = Specification.where((Specification)andSpecs).and((Specification)entry.getKey());
                continue;
            }
            orSpecs = Specification.where((Specification)orSpecs).or((Specification)entry.getKey());
        }
        Specification specificationResult = Specification.where(andSpecs).and(orSpecs);
        return new GenericSpecificationContainer(specificationResult, this.parameters);
    }
}

