package com.github.kklisura.cdt.protocol.types.accessibility;

/*-
 * #%L
 * cdt-java-client
 * %%
 * Copyright (C) 2018 - 2019 Kenan Klisura
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.fasterxml.jackson.annotation.JsonProperty;

/** Enum of possible property types. */
public enum AXValueType {
  @JsonProperty("boolean")
  BOOLEAN,
  @JsonProperty("tristate")
  TRISTATE,
  @JsonProperty("booleanOrUndefined")
  BOOLEAN_OR_UNDEFINED,
  @JsonProperty("idref")
  IDREF,
  @JsonProperty("idrefList")
  IDREF_LIST,
  @JsonProperty("integer")
  INTEGER,
  @JsonProperty("node")
  NODE,
  @JsonProperty("nodeList")
  NODE_LIST,
  @JsonProperty("number")
  NUMBER,
  @JsonProperty("string")
  STRING,
  @JsonProperty("computedString")
  COMPUTED_STRING,
  @JsonProperty("token")
  TOKEN,
  @JsonProperty("tokenList")
  TOKEN_LIST,
  @JsonProperty("domRelation")
  DOM_RELATION,
  @JsonProperty("role")
  ROLE,
  @JsonProperty("internalRole")
  INTERNAL_ROLE,
  @JsonProperty("valueUndefined")
  VALUE_UNDEFINED
}
