/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.network;

import android.content.Context;
import android.support.annotation.WorkerThread;
import com.krishna.fileloader.request.FileLoadRequest;
import com.krishna.fileloader.utility.AndroidFileManager;
import java.io.File;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class FileDownloader {
    private FileLoadRequest fileLoadRequest;
    private OkHttpClient httpClient;
    private Context context;

    public FileDownloader(Context context, FileLoadRequest fileLoadRequest) {
        this.fileLoadRequest = fileLoadRequest;
        this.httpClient = new OkHttpClient();
        this.context = context.getApplicationContext();
    }

    @WorkerThread
    public File download() throws Exception {
        Request request = new Request.Builder().url(this.fileLoadRequest.getUri()).build();
        Response response = this.httpClient.newCall(request).execute();
        if (!response.isSuccessful() || response.body() == null) {
            throw new IOException("Failed to download file: " + response);
        }
        File downloadedFile = AndroidFileManager.getFileForRequest(this.context, this.fileLoadRequest.getUri(), this.fileLoadRequest.getDirectoryName(), this.fileLoadRequest.getDirectoryType());
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)downloadedFile));
        sink.writeAll((Source)response.body().source());
        sink.close();
        return downloadedFile;
    }
}

