/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.utility;

import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    private static final String TAG = "MD5";

    public static boolean checkMD5(String md5, File updateFile) {
        if (TextUtils.isEmpty((CharSequence)md5) || updateFile == null) {
            Log.e((String)TAG, (String)"MD5 string empty or updateFile null");
            return false;
        }
        String calculatedDigest = MD5.calculateMD5(updateFile);
        if (calculatedDigest == null) {
            Log.e((String)TAG, (String)"calculatedDigest null");
            return false;
        }
        Log.v((String)TAG, (String)("Calculated digest: " + calculatedDigest));
        Log.v((String)TAG, (String)("Provided digest: " + md5));
        return calculatedDigest.equalsIgnoreCase(md5);
    }

    public static String calculateMD5(File updateFile) {
        FileInputStream is;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(TAG);
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)"Exception while getting digest", (Throwable)e);
            return null;
        }
        try {
            is = new FileInputStream(updateFile);
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"Exception while getting FileInputStream", (Throwable)e);
            return null;
        }
        byte[] buffer = new byte[8192];
        try {
            int read;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String output = bigInt.toString(16);
            String string = output = String.format("%32s", output).replace(' ', '0');
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for MD5", e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception on closing MD5 input stream", (Throwable)e);
            }
        }
    }
}

