/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.builder;

import android.content.Context;
import com.krishna.fileloader.FileLoader;
import com.krishna.fileloader.MultiFileDownloadTask;
import com.krishna.fileloader.listener.MultiFileDownloadListener;
import com.krishna.fileloader.request.MultiFileLoadRequest;
import com.krishna.fileloader.utility.Utils;
import java.util.List;

public class MultiFileDownloader {
    private Context context;
    private String directoryName = "file_loader";
    private int directoryType = 2;
    private MultiFileDownloadListener listener;
    private boolean forceLoadFromNetwork;
    private MultiFileDownloadTask multiFileDownloadTask;

    public MultiFileDownloader(Context context) {
        this.context = context;
    }

    public MultiFileDownloader fromDirectory(String directoryName, @FileLoader.DirectoryType int directoryType) {
        this.directoryName = directoryName;
        this.directoryType = directoryType;
        return this;
    }

    public MultiFileDownloader progressListener(MultiFileDownloadListener listener) {
        this.listener = listener;
        return this;
    }

    public void loadMultiple(String ... uris) {
        Object[] loadRequestArr = new MultiFileLoadRequest[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            MultiFileLoadRequest loadRequest = new MultiFileLoadRequest(uris[i], this.directoryName, this.directoryType, this.forceLoadFromNetwork);
            loadRequestArr[i] = loadRequest;
        }
        this.multiFileDownloadTask = new MultiFileDownloadTask(this.context, this.listener);
        this.multiFileDownloadTask.executeOnExecutor(Utils.getThreadPoolExecutor(), loadRequestArr);
    }

    public void loadMultiple(boolean forceLoadFromNetwork, String ... uris) {
        this.forceLoadFromNetwork = forceLoadFromNetwork;
        this.loadMultiple(uris);
    }

    public void loadMultiple(boolean forceLoadFromNetwork, List<MultiFileLoadRequest> multiFileLoadRequestList) {
        this.forceLoadFromNetwork = forceLoadFromNetwork;
        Object[] loadRequestArr = new MultiFileLoadRequest[multiFileLoadRequestList.size()];
        for (int i = 0; i < multiFileLoadRequestList.size(); ++i) {
            loadRequestArr[i] = multiFileLoadRequestList.get(i);
        }
        this.multiFileDownloadTask = new MultiFileDownloadTask(this.context, this.listener);
        this.multiFileDownloadTask.executeOnExecutor(Utils.getThreadPoolExecutor(), loadRequestArr);
    }

    public void loadMultiple(List<MultiFileLoadRequest> multiFileLoadRequestList) {
        this.loadMultiple(false, multiFileLoadRequestList);
    }

    public void cancelLoad() {
        if (this.multiFileDownloadTask != null) {
            this.multiFileDownloadTask.cancel(true);
        }
    }
}

